/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.simul;

import fr.inra.sad.bagap.apiland.core.element.map.DynamicMap;
import fr.inra.sad.bagap.apiland.simul.OutputManager;
import fr.inra.sad.bagap.apiland.simul.Simulation;
import fr.inra.sad.bagap.apiland.simul.SimulationFactory;
import fr.inra.sad.bagap.apiland.simul.SimulationManager;
import fr.inra.sad.bagap.apiland.simul.Simulator;
import fr.inra.sad.bagap.apiland.simul.model.APILandModel;
import fr.inra.sad.bagap.apiland.simul.model.ModelManager;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Scenario
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean run;
    private int number;
    private Simulator simulator;
    private APILandModel model;
    private Map<String, String> settings;
    private String folder;

    public Scenario(Simulator simulator, int number) {
        this.simulator = simulator;
        this.number = number;
        this.settings = new HashMap<String, String>();
    }

    public String toString() {
        return "scenario_" + this.number;
    }

    public String folder() {
        return this.folder;
    }

    public SimulationManager manager() {
        return this.simulator.manager();
    }

    public SimulationFactory factory() {
        return this.simulator.factory();
    }

    public Simulator simulator() {
        return this.simulator;
    }

    public OutputManager outputs() {
        return this.simulator.outputs();
    }

    public int number() {
        return this.number;
    }

    private void add(Simulation simulation) {
    }

    protected void init() {
        this.model = this.simulator.model();
        this.folder = this.manager().expFolder() + "/outputs/scenario_" + this.number + "/";
        new File(this.folder).mkdir();
        this.run = false;
        for (Map.Entry<String, String> e : this.settings.entrySet()) {
            this.manager().setSettings(e.getKey(), e.getValue());
        }
        this.initModel();
        this.outputs().init(this);
        if (this.manager().simulations() > 1) {
            // empty if block
        }
    }

    protected void init(String propertiesFile) {
        this.manager().init(propertiesFile);
        this.init();
    }

    protected void initModel() {
    }

    private void loadModel() {
        try {
            this.model = (APILandModel)ModelManager.load(this.manager().expFolder() + "/outputs/simulator.model");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void saveModel() {
        try {
            ModelManager.save(this.model, this.folder + "scenario.model");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void run() {
        this.manager().display("run scenario " + this.simulator().number() + "_" + this.number);
        if (!this.run) {
            int success = 0;
            int i = 0;
            while (this.conditionContinuation(i, success)) {
                this.manager().setCancelled(false);
                Simulation s = this.factory().createSimulation(this, i + 1);
                this.add(s);
                s.init();
                if (s.run()) {
                    ++success;
                }
                s.close();
                ++i;
            }
            this.outputs().calculate(this);
        }
    }

    protected boolean conditionContinuation(int index, int success) {
        return index < this.manager().simulations() || success < this.manager().success();
    }

    protected void close() {
        this.manager().display("close scenario " + this.simulator().number() + "_" + this.number);
        this.run = true;
        this.outputs().close(this);
        File folderFile = new File(this.folder);
        if (folderFile != null && folderFile.list() != null && folderFile.list().length == 0) {
            folderFile.delete();
        }
    }

    public APILandModel model() {
        return this.model;
    }

    public DynamicMap map() {
        return this.model.map();
    }

    public void setSettings(String key, String value) {
        this.settings.put(key, value);
    }

    public void setSimulations(Simulation[] simulations) {
        throw new UnsupportedOperationException();
    }

    public void setSimulator(Simulator simulator) {
        this.simulator = simulator;
    }

    public void setModel(APILandModel model) {
        this.model = model;
    }

    public void setSettings(Map<String, String> settings) {
        this.settings = settings;
    }

    public void delete() {
        this.simulator().deleteScenario(this);
        this.simulator = null;
        this.model.delete();
        this.model = null;
        this.settings.clear();
        this.settings = null;
    }
}

