/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.patch;

import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.patch.Envelope;
import fr.inra.sad.bagap.apiland.patch.Patch;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class MapPatch
implements Patch {
    private int value;
    private Map<Integer, Set<Integer>> pixels;

    public MapPatch(int v) {
        this.value = v;
        this.pixels = new TreeMap<Integer, Set<Integer>>();
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public boolean touches(Pixel p) {
        if (this.pixels.containsKey(p.y() - 1)) {
            for (Integer x : this.pixels.get(p.y() - 1)) {
                if (!new Pixel(x, p.y() - 1).rootTouches(p)) continue;
                return true;
            }
        }
        if (this.pixels.containsKey(p.y())) {
            for (Integer x : this.pixels.get(p.y())) {
                if (!new Pixel(x, p.y()).rootTouches(p)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean contains(Pixel p) {
        if (this.pixels.containsKey(p.y())) {
            for (Integer x : this.pixels.get(p.y())) {
                if (x.intValue() != p.x()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void add(Pixel p) {
        if (!this.pixels.containsKey(p.y())) {
            this.pixels.put(p.y(), new TreeSet());
        }
        this.pixels.get(p.y()).add(p.x());
    }

    private void addAll(int y, Set<Integer> xs) {
        if (!this.pixels.containsKey(y) || this.pixels.get(y).size() == 0) {
            this.pixels.put(y, xs);
        } else {
            this.pixels.get(y).addAll(xs);
        }
    }

    @Override
    public void addAll(Patch pa) {
        for (Map.Entry<Integer, Set<Integer>> e : ((MapPatch)pa).pixels.entrySet()) {
            this.addAll(e.getKey(), e.getValue());
        }
    }

    @Override
    public Set<Pixel> pixels() {
        TreeSet<Pixel> px = new TreeSet<Pixel>();
        for (int y : this.pixels.keySet()) {
            for (int x : this.pixels.get(y)) {
                px.add(new Pixel(x, y));
            }
        }
        return px;
    }

    @Override
    public void remove(Pixel p) {
        this.pixels.get(p.y()).remove(p.x());
        if (this.pixels.get(p.y()).size() == 0) {
            this.pixels.remove(p.y());
        }
    }

    @Override
    public int size() {
        int size = 0;
        for (Set<Integer> p : this.pixels.values()) {
            size += p.size();
        }
        return size;
    }

    @Override
    public double getArea() {
        return (double)this.size() * Pixel.getCellSize() * Pixel.getCellSize();
    }

    @Override
    public void display() {
        for (Pixel p : this.pixels()) {
            System.out.print(p + ", ");
        }
        System.out.println();
    }

    @Override
    public void upPixels() {
        TreeMap<Integer, Set<Integer>> pixels2 = new TreeMap<Integer, Set<Integer>>();
        for (Map.Entry<Integer, Set<Integer>> e : this.pixels.entrySet()) {
            if (e.getKey() <= 0) continue;
            pixels2.put(e.getKey() - 1, e.getValue());
        }
        this.pixels = pixels2;
    }

    @Override
    public Pixel pixel() {
        int y = this.pixels.keySet().iterator().next();
        int x = this.pixels.get(y).iterator().next();
        return new Pixel(x, y);
    }

    @Override
    public boolean equals(Patch pi) {
        int x2;
        int y2;
        int y1 = this.pixels.keySet().iterator().next();
        if (y1 != (y2 = ((MapPatch)pi).pixels.keySet().iterator().next().intValue())) {
            return false;
        }
        int x1 = this.pixels.values().iterator().next().iterator().next();
        return x1 == (x2 = ((MapPatch)pi).pixels.values().iterator().next().iterator().next().intValue());
    }

    @Override
    public Envelope getEnvelope() {
        int minx = Integer.MAX_VALUE;
        int maxx = Integer.MIN_VALUE;
        int miny = Integer.MAX_VALUE;
        int maxy = Integer.MIN_VALUE;
        for (int y : this.pixels.keySet()) {
            miny = Math.min(miny, y);
            maxy = Math.max(maxy, y);
            for (int x : this.pixels.get(y)) {
                minx = Math.min(minx, x);
                maxx = Math.max(maxx, x);
            }
        }
        return new Envelope(minx, maxx, miny, maxy);
    }
}

