/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.util;

import fr.inra.sad.bagap.apiland.core.util.TransitionMatrix;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TransitionMatrixBuilder<O extends Serializable> {
    private Map<O, Map<O, Double>> transitionRate;

    public TransitionMatrixBuilder() {
        this.reset();
    }

    private void reset() {
        this.transitionRate = new HashMap<O, Map<O, Double>>();
    }

    public void setTransitionRate(O in, O out, double rate) {
        if (!this.transitionRate.containsKey(in)) {
            this.transitionRate.put(in, new HashMap());
        }
        this.transitionRate.get(in).put(out, rate);
    }

    private boolean isValid() {
        for (Serializable in : this.transitionRate.keySet()) {
            if (this.transitionRate.size() != this.transitionRate.get(in).size()) {
                throw new IllegalArgumentException("size problem");
            }
            double sum = 0.0;
            for (Serializable out : this.transitionRate.get(in).keySet()) {
                sum += this.transitionRate.get(in).get(out).doubleValue();
            }
            if (!(sum < 99.0) && !(sum > 101.0)) continue;
            throw new IllegalArgumentException("sum problem : not equals to '100'");
        }
        return true;
    }

    public TransitionMatrix<O> build() {
        TransitionMatrix tMat = null;
        if (this.isValid()) {
            ArrayList<Serializable> lo = new ArrayList<Serializable>(this.transitionRate.size());
            double[][] rates = new double[this.transitionRate.size()][];
            for (Serializable in : this.transitionRate.keySet()) {
                lo.add(in);
            }
            for (Serializable in : this.transitionRate.keySet()) {
                rates[lo.indexOf((Object)in)] = new double[this.transitionRate.size()];
                for (Serializable out : this.transitionRate.keySet()) {
                    rates[lo.indexOf((Object)in)][lo.indexOf((Object)out)] = this.transitionRate.get(in).get(out);
                }
            }
            tMat = new TransitionMatrix(lo, rates);
        }
        this.reset();
        return tMat;
    }
}

