/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.time.period;

import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.Interval;
import fr.inra.sad.bagap.apiland.core.time.Time;
import fr.inra.sad.bagap.apiland.core.time.period.Date;
import fr.inra.sad.bagap.apiland.core.time.period.Moment;
import fr.inra.sad.bagap.apiland.core.time.period.Month;
import java.util.StringTokenizer;

public class Period
extends Moment
implements Comparable<Period> {
    private static final long serialVersionUID = 1L;
    private Moment start;
    private Moment end;

    protected Period() {
    }

    public Period(int startDay, Month startMonth, int endDay, Month endMonth) {
        this.start = new Date(startDay, startMonth);
        this.end = new Date(endDay, endMonth);
    }

    public Period(Interval inter) {
        this.start = new Date(inter.start());
        this.end = new Date(inter.end());
    }

    public Period(int startDay, int startMonth, int endDay, int endMonth) {
        this.start = new Date(startDay, startMonth);
        this.end = new Date(endDay, endMonth);
    }

    public Period(Moment start, Moment end) {
        this.start = start;
        this.end = end;
    }

    public Period(int startDay, int startMonth, Moment end) {
        this.start = new Date(startDay, startMonth);
        this.end = end;
    }

    public Period(Moment start, int endDay, int endMonth) {
        this.start = start;
        this.end = new Date(endDay, endMonth);
    }

    public Period(String period) {
        StringTokenizer st = new StringTokenizer(period, "-");
        this.start = new Date(st.nextToken());
        this.end = new Date(st.nextToken());
    }

    public String toString() {
        return this.start + "-" + this.end;
    }

    public boolean equals(Object o) {
        return o instanceof Period && this.start.equals(((Period)o).start()) && this.end.equals(((Period)o).end());
    }

    public int getDayCount(boolean bissextile) {
        if (this.end.end().getMonth() < this.start.start().getMonth()) {
            return 365 - (this.start.start().getDayOfYear(bissextile) - this.end.end().getDayOfYear(bissextile));
        }
        return this.end.end().getDayOfYear(bissextile) - this.start.start().getDayOfYear(bissextile);
    }

    public boolean isBefore(Instant instant, Period period) {
        Interval iPeriod = period.getActiveInterval(instant);
        Interval iCurent = this.getActiveInterval(iPeriod);
        return iCurent.isBefore(instant);
    }

    public boolean isAfter(Instant instant, Period period) {
        Interval iPeriod = period.getActiveInterval(instant);
        Interval iCurent = this.getActiveInterval(iPeriod);
        return iCurent.isAfter(instant);
    }

    public boolean contains(Instant instant, Period period) {
        Interval iPeriod = period.getActiveInterval(instant);
        Interval iCurent = this.getActiveInterval(iPeriod);
        return iCurent.isActive(instant);
    }

    public Interval getActiveInterval(Instant t) {
        Instant iEnd;
        Interval interval = null;
        Instant iBegin = new Instant(this.start().getDay(), this.start().getMonth(), Time.getYear(t));
        if (iBegin.isBefore(iEnd = new Instant(this.end().getDay(), this.end().getMonth(), Time.getYear(t)))) {
            interval = new Interval(iBegin, iEnd);
            if (interval.isActive(t)) {
                return interval;
            }
        } else {
            Instant iEnd2 = new Instant(this.end().getDay(), this.end().getMonth(), Time.getYear(t) + 1);
            interval = new Interval(iBegin, iEnd2);
            if (interval.isActive(t)) {
                return interval;
            }
            iBegin = new Instant(this.start().getDay(), this.start().getMonth(), Time.getYear(t) - 1);
            interval = new Interval(iBegin, iEnd);
            if (interval.isActive(t)) {
                return interval;
            }
        }
        return null;
    }

    public Interval getActiveInterval(Interval t) {
        Interval aInterval = null;
        if (Time.getYear(t.start()) == Time.getYear(t.end())) {
            Instant iEnd;
            Instant iBegin = new Instant(this.start().getDay(), this.start().getMonth(), Time.getYear(t.start()));
            if (iBegin.isBefore(iEnd = new Instant(this.end().getDay(), this.end().getMonth(), Time.getYear(t.end()))) && (aInterval = new Interval(iBegin, iEnd)).within(t)) {
                return aInterval;
            }
        } else {
            Instant iEnd;
            Instant iBegin = new Instant(this.start().getDay(), this.start().getMonth(), Time.getYear(t.start()));
            if (iBegin.isBefore(iEnd = new Instant(this.end().getDay(), this.end().getMonth(), Time.getYear(t.start())))) {
                aInterval = new Interval(iBegin, iEnd);
                if (aInterval.within(t)) {
                    return aInterval;
                }
                iBegin = new Instant(this.start().getDay(), this.start().getMonth(), Time.getYear(t.end()));
                aInterval = new Interval(iBegin, iEnd = new Instant(this.start().getDay(), this.start().getMonth(), Time.getYear(t.end())));
                if (aInterval.within(t)) {
                    return aInterval;
                }
            } else {
                iEnd = new Instant(this.end().getDay(), this.end().getMonth(), Time.getYear(t.end()));
                aInterval = new Interval(iBegin, iEnd);
                if (aInterval.within(t)) {
                    return aInterval;
                }
            }
        }
        return null;
    }

    public Interval getActiveInterval(int year) {
        if (this.start instanceof Date && this.end instanceof Date) {
            if (((Date)this.start).isBefore((Date)this.end)) {
                return new Interval(((Date)this.start).getDay(), ((Date)this.start).getMonth(), year, ((Date)this.end).getDay(), ((Date)this.end).getMonth(), year);
            }
            return new Interval(((Date)this.start).getDay(), ((Date)this.start).getMonth(), year, ((Date)this.end).getDay(), ((Date)this.end).getMonth(), year + 1);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Date start() {
        return this.start.start();
    }

    @Override
    public Date end() {
        return this.end.end();
    }

    @Override
    public boolean isActive(Instant t) {
        return Time.getDayOfYear(t) >= this.start.start().getDayOfYear(Time.isBissextile(t)) ? Time.getDayOfYear(t) <= this.start.start().getDayOfYear(Time.isBissextile(t)) + this.getDayCount(Time.isBissextile(t)) : Time.getDayOfYear(t) <= this.end.end().getDayOfYear(Time.isBissextile(t)) && Time.getDayOfYear(t) <= this.getDayCount(Time.isBissextile(t)) - (365 - this.start.start().getDayOfYear(Time.isBissextile(t)));
    }

    @Override
    public Date getBefore(boolean bissextile, int delay) {
        return new Date(this.start().getDayOfYear(bissextile) - delay);
    }

    @Override
    public Date getAfter(boolean bissextile, int delay) {
        return new Date(this.end().getDayOfYear(bissextile) + delay);
    }

    public static Period get(String period) {
        if (Month.isMonth(period)) {
            return Month.get(period);
        }
        StringTokenizer st = new StringTokenizer(period, "-");
        String start = st.nextToken();
        String end = st.nextToken();
        st = new StringTokenizer(start, "/");
        int sd = Integer.valueOf(st.nextToken());
        int sm = Integer.valueOf(st.nextToken());
        st = new StringTokenizer(end, "/");
        int ed = Integer.valueOf(st.nextToken());
        int em = Integer.valueOf(st.nextToken());
        return new Period(sd, sm, ed, em);
    }

    @Override
    public int compareTo(Period p) {
        if (this.start().getDayOfYear(true) < p.start().getDayOfYear(true)) {
            return -1;
        }
        if (this.start().getDayOfYear(true) > p.start().getDayOfYear(true)) {
            return 1;
        }
        return 0;
    }
}

