/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.time;

import fr.inra.sad.bagap.apiland.core.time.ComplexTime;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.Interval;
import fr.inra.sad.bagap.apiland.core.time.MultiInstant;
import fr.inra.sad.bagap.apiland.core.time.MultiInterval;
import fr.inra.sad.bagap.apiland.core.time.Temporal;
import fr.inra.sad.bagap.apiland.core.time.TimeException;
import fr.inra.sad.bagap.apiland.core.time.TimeManager;
import fr.inra.sad.bagap.apiland.core.time.Timer;
import java.util.Date;

public abstract class Time
implements Temporal,
Comparable<Time> {
    @Override
    public Time clone() {
        try {
            return (Time)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected abstract boolean isSmooth();

    public abstract Time smooth();

    @Override
    public Time getTime() {
        return this;
    }

    @Override
    public void setTime(Time t) {
        throw new UnsupportedOperationException();
    }

    public abstract long getLength();

    public abstract Instant start();

    public abstract Instant end();

    public abstract void setStart(Instant var1) throws TimeException;

    public abstract void setEnd(Instant var1) throws TimeException;

    public abstract boolean isBefore(Time var1);

    public abstract boolean isAfter(Time var1);

    public int hashCode() {
        return 15;
    }

    public boolean equals(Object o) {
        if (o instanceof Time) {
            return this.equals((Time)o);
        }
        return false;
    }

    public abstract boolean equals(Time var1);

    protected abstract boolean equalsInstant(Instant var1);

    protected abstract boolean equalsInterval(Interval var1);

    protected abstract <T extends Time> boolean equalsComplexTime(ComplexTime<T> var1);

    public abstract boolean contains(Time var1);

    protected abstract boolean containsInterval(Interval var1);

    protected abstract <T extends Time> boolean containsComplexTime(ComplexTime<T> var1);

    public abstract boolean within(Time var1);

    protected abstract boolean withinInstant(Instant var1);

    protected abstract <T extends Time> boolean withinComplexTime(ComplexTime<T> var1);

    public abstract boolean intersects(Time var1);

    protected abstract boolean intersectInterval(Interval var1);

    public abstract boolean touches(Time var1);

    protected abstract boolean touchesInstant(Instant var1);

    protected abstract boolean touchesInterval(Interval var1);

    protected abstract <T extends Time> boolean touchesComplexTime(ComplexTime<T> var1);

    public abstract boolean crosses(Time var1);

    protected abstract boolean crossesInstant(Instant var1);

    protected abstract boolean crossesInterval(Interval var1);

    protected abstract <T extends Time> boolean crossesComplexTime(ComplexTime<T> var1);

    public abstract boolean disjoint(Time var1);

    protected abstract boolean disjointInterval(Interval var1);

    public abstract boolean overlaps(Time var1);

    protected abstract boolean overlapsInstant(Instant var1);

    protected abstract boolean overlapsInterval(Interval var1);

    protected abstract <T extends Time> boolean overlapsComplexTime(ComplexTime<T> var1);

    public abstract Time deleteTime(Time var1);

    protected abstract Time deleteInstant(Instant var1);

    protected abstract Time deleteInterval(Interval var1);

    protected abstract <T extends Time> Time deleteComplexTime(ComplexTime<T> var1);

    protected abstract Time deleteMultiInstant(MultiInstant var1);

    protected abstract Time deleteMultiInterval(MultiInterval var1);

    public abstract Time addTime(Time var1);

    protected abstract Time addInstant(Instant var1);

    protected abstract Time addInterval(Interval var1);

    protected abstract <T extends Time> Time addComplexTime(ComplexTime<T> var1);

    protected abstract Time addMultiInstant(MultiInstant var1);

    protected abstract Time addMultiInterval(MultiInterval var1);

    public static Time add(Time t1, Time t2) {
        if (t1 == null) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        return t1.addTime(t2);
    }

    public static Time delete(Time t1, Time t2) {
        if (t1 == null) {
            return null;
        }
        if (t2 == null) {
            return t1;
        }
        return t1.deleteTime(t2);
    }

    public static Interval addTimeToInterval(Interval target, Time src) {
        if (target == null) {
            return new Interval(src.start(), src.end());
        }
        if (src.start().isBefore(target.start())) {
            if (src.end().isAfter(target.end())) {
                return new Interval(src.start(), src.end());
            }
            return new Interval(src.start(), target.end());
        }
        if (src.end().isAfter(target.end())) {
            return new Interval(target.start(), src.end());
        }
        return target;
    }

    public static int getDayOfMonth(Instant t) {
        Timer.getCalendar().setTime(t.date);
        return Timer.getCalendar().get(5);
    }

    public static int getDayOfYear(Instant t) {
        Timer.getCalendar().setTime(t.date);
        return Timer.getCalendar().get(6);
    }

    public static Instant getPreviousDay(Instant t) {
        return new Instant(t.date.getTime() - 86400000L);
    }

    public static Instant getNextDay(Instant t) {
        return new Instant(t.date.getTime() + 86400000L);
    }

    public static Instant getDayAfter(Instant t, long next) {
        return new Instant(t.date.getTime() + next * 86400000L);
    }

    public static Instant getDayBefore(Instant t, long before) {
        return new Instant(t.date.getTime() - before * 86400000L);
    }

    public static int getMonth(Instant t) {
        Timer.getCalendar().setTime(t.date);
        return Timer.getCalendar().get(2) + 1;
    }

    public static int getYear(Instant t) {
        Timer.getCalendar().setTime(t.date);
        return Timer.getCalendar().get(1);
    }

    @Override
    public void kill(Instant t) throws TimeException {
        throw new UnsupportedOperationException();
    }

    public static Time kill(Time t1, Instant t2) {
        if (t1 != null) {
            return t1.killTime(t2);
        }
        return t2;
    }

    protected abstract Time killTime(Instant var1);

    public static Instant get(int day, int month, int year) {
        return TimeManager.get(day, month, year);
    }

    public static Instant get(int year) {
        return TimeManager.get(1, 1, year);
    }

    public static Instant get(String ddMMyyyy) {
        return TimeManager.get(ddMMyyyy);
    }

    public static Instant get(Date d) {
        return TimeManager.get(d);
    }

    public static boolean isBissextile(Instant t) {
        int y = Time.getYear(t);
        if (y % 4 == 0) {
            if (y % 100 == 0) {
                return y % 400 == 0;
            }
            return true;
        }
        return false;
    }

    public static Interval getIntervalYear_N(Instant t, int year_n) {
        assert (year_n > 0);
        return new Interval(Time.get(Time.getDayOfMonth(t), Time.getMonth(t), Time.getYear(t) - year_n), t);
    }

    protected abstract boolean isTimeNull();

    @Override
    public int compareTo(Time t) {
        if (this.isBefore(t)) {
            return -1;
        }
        if (t.isBefore(this)) {
            return 1;
        }
        return 0;
    }
}

