/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.time;

import fr.inra.sad.bagap.apiland.core.time.ComplexTime;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.Interval;
import fr.inra.sad.bagap.apiland.core.time.MultiInterval;
import fr.inra.sad.bagap.apiland.core.time.Time;
import java.util.List;

public class MultiInstant
extends ComplexTime<Instant> {
    private static final long serialVersionUID = 1L;

    public MultiInstant() {
    }

    public MultiInstant(List<Instant> l) {
        super(l);
    }

    @Override
    public MultiInstant clone() {
        return (MultiInstant)super.clone();
    }

    @Override
    protected boolean withinInstant(Instant t) {
        return this.times.size() == 1 && ((Instant)this.times.get(0)).isActive(t);
    }

    @Override
    protected boolean crossesInstant(Instant t) {
        return this.isActive(t) && this.times.size() != 1;
    }

    @Override
    public Time addTime(Time t) {
        return t.addMultiInstant(this);
    }

    @Override
    protected Time addInstant(Instant t) {
        if (this.contains(t)) {
            return this.clone();
        }
        MultiInstant mi = this.clone();
        mi.add(t);
        return mi.smooth();
    }

    @Override
    protected Time addInterval(Interval t) {
        ComplexTime<Time> time = new ComplexTime<Time>();
        for (Instant tt : this) {
            time.add(tt);
        }
        time.add(t);
        return time.smooth();
    }

    @Override
    protected <TT extends Time> Time addComplexTime(ComplexTime<TT> t) {
        Time ct = t.clone();
        for (Instant time : this) {
            ((ComplexTime)ct).add(time);
        }
        return ((ComplexTime)ct).smooth();
    }

    @Override
    protected Time addMultiInstant(MultiInstant t) {
        MultiInstant mi = this.clone();
        for (Instant i : t) {
            mi.add(i);
        }
        return mi.smooth();
    }

    @Override
    protected Time addMultiInterval(MultiInterval t) {
        return t.addMultiInstant(this);
    }
}

