/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix;

import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.IteratorMatrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixManager;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixType;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.SparseCoordinate;
import fr.inra.sad.bagap.apiland.core.util.Couple;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SparseMatrix
implements Matrix {
    private SparseCoordinate[] x;
    private SparseCoordinate[] y;
    private double minX;
    private double maxY;
    private double minY;
    private double maxX;
    private int noDataValue;
    private double cellsize;
    private String file;
    private Set<Integer> values;

    public SparseMatrix(int width, int height, double cellsize, double minX, double maxX, double minY, double maxY, int noDataValue) {
        this.x = new SparseCoordinate[width];
        this.y = new SparseCoordinate[height];
        this.cellsize = cellsize;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.noDataValue = noDataValue;
        this.values = new HashSet<Integer>();
    }

    public SparseMatrix(Matrix matrix) {
        this.x = new SparseCoordinate[matrix.width()];
        this.y = new SparseCoordinate[matrix.height()];
        this.cellsize = matrix.cellsize();
        this.minX = matrix.minX();
        this.maxY = matrix.maxY();
        this.noDataValue = matrix.noDataValue();
        this.values = new HashSet<Integer>();
    }

    @Override
    public MatrixType getType() {
        return MatrixType.SPARSE;
    }

    @Override
    public void init(double v) {
        this.noDataValue = new Double(v).intValue();
    }

    @Override
    public void visualize() {
        MatrixManager.visualize(this);
    }

    @Override
    public void display() {
    }

    @Override
    public double get(int x, int y) {
        try {
            if (this.x[x].getY() == y) {
                return this.x[x].getValue();
            }
            if (this.x[x].getY() > y) {
                return this.noDataValue;
            }
            if (this.y[y].getX() == x) {
                return this.y[y].getValue();
            }
            if (this.y[y].getX() > x) {
                return this.noDataValue;
            }
            if (y - this.x[x].getY() < x - this.y[y].getX()) {
                return this.x[x].getY(y, this.noDataValue);
            }
            return this.y[y].getX(x, this.noDataValue);
        }
        catch (Exception ex) {
            return this.noDataValue;
        }
    }

    @Override
    public double get(Pixel p) {
        return this.get(p.x(), p.y());
    }

    @Override
    public void put(int x, int y, double value) {
        if (value != (double)this.noDataValue) {
            SparseCoordinate cs = new SparseCoordinate(x, y, value);
            if (this.x[x] == null) {
                this.x[x] = cs;
            } else if (this.x[x].getY() < y) {
                this.x[x].putY(cs);
            } else if (this.x[x].getY() == y) {
                this.x[x].setValue(value);
            } else if (this.x[x].getY() > y) {
                cs.setV(this.x[x]);
                this.x[x] = cs;
            }
            if (this.y[y] == null) {
                this.y[y] = cs;
            } else if (this.y[y].getX() < x) {
                this.y[y].putX(cs);
            } else if (this.y[y].getX() == x) {
                this.y[y].setValue(value);
            } else if (this.y[y].getX() > x) {
                cs.setH(this.y[y]);
                this.y[y] = cs;
            }
            this.values.add(new Double(value).intValue());
        }
    }

    @Override
    public void put(Pixel p, double value) {
        this.put(p.x(), p.y(), value);
    }

    @Override
    public void put(Raster r, double value) {
        for (Pixel p : r) {
            this.put(p, value);
        }
    }

    @Override
    public int width() {
        return this.x.length;
    }

    @Override
    public int height() {
        return this.y.length;
    }

    @Override
    public double maxX() {
        return this.maxX;
    }

    @Override
    public double maxY() {
        return this.maxY;
    }

    @Override
    public double minX() {
        return this.minX;
    }

    @Override
    public double minY() {
        return this.minY;
    }

    @Override
    public double cellsize() {
        return this.cellsize;
    }

    @Override
    public int noDataValue() {
        return this.noDataValue;
    }

    @Override
    public void setFile(String file) {
        this.file = file;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public Set<Integer> values() {
        return this.values;
    }

    @Override
    public Iterator<Pixel> iterator() {
        return new IteratorMatrix(this);
    }

    @Override
    public double getActiveArea() {
        double area = 0.0;
        for (Pixel p : this) {
            if (this.get(p) == (double)this.noDataValue) continue;
            area += Math.pow(this.cellsize, 2.0);
        }
        return area;
    }

    @Override
    public void getCouples(Matrix horizontals, Matrix verticals) {
        int y;
        for (y = 0; y < this.height() - 1; ++y) {
            for (int x = 0; x < this.width() - 1; ++x) {
                System.out.println(x + " " + y);
                verticals.put(x, y, Couple.get(new Double(this.get(x, y)).intValue(), new Double(this.get(x, y + 1)).intValue()));
                horizontals.put(x, y, Couple.get(new Double(this.get(x, y)).intValue(), new Double(this.get(x + 1, y)).intValue()));
            }
        }
        for (y = 0; y < this.height() - 1; ++y) {
            verticals.put(this.width() - 1, y, Couple.get(new Double(this.get(this.width() - 1, y)).intValue(), new Double(this.get(this.width() - 1, y + 1)).intValue()));
        }
        for (int x = 0; x < this.width() - 1; ++x) {
            horizontals.put(x, this.height() - 1, Couple.get(new Double(this.get(x, this.height() - 1)).intValue(), new Double(this.get(x + 1, this.height() - 1)).intValue()));
        }
    }

    @Override
    public int tileWidth() {
        return this.width();
    }

    @Override
    public int tileHeight() {
        return this.height();
    }

    @Override
    public int numXTiles() {
        return 1;
    }

    @Override
    public int numYTiles() {
        return 1;
    }

    @Override
    public boolean contains(Pixel p) {
        return false;
    }

    @Override
    public double minV() {
        return 0.0;
    }

    @Override
    public double maxV() {
        return 0.0;
    }

    @Override
    public boolean contains(int x, int y) {
        return false;
    }
}

