/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix;

import com.sun.media.jai.widget.DisplayJAI;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixType;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.TiledMatrixIterator;
import fr.inra.sad.bagap.apiland.core.util.Couple;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.TiledImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class JaiMatrix3
implements Matrix {
    private static final long serialVersionUID = 1L;
    private PlanarImage pi;
    private RandomIter ite;
    private double[] pixel;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private double cellsize;
    private double minV;
    private double maxV;
    private String file;
    private Set<Integer> values;

    public JaiMatrix3(String image) {
        this((PlanarImage)JAI.create((String)"fileload", (Object)image));
        this.setFile(image);
    }

    public JaiMatrix3(PlanarImage pi) {
        this(pi, true);
    }

    public JaiMatrix3(PlanarImage pi, boolean read) {
        this.pi = pi;
        this.ite = RandomIterFactory.create((RenderedImage)this.pi, null);
        this.pixel = new double[1];
        if (read) {
            this.initValues();
        }
    }

    public JaiMatrix3(PlanarImage pi, Set<Integer> values) {
        this.pi = pi;
        this.ite = RandomIterFactory.create((RenderedImage)this.pi, null);
        this.pixel = new double[1];
        this.values = values;
    }

    public JaiMatrix3(double cellsize, double minx, double maxx, double miny, double maxy, PlanarImage pi) {
        this(pi);
        this.minX = minx;
        this.maxX = maxx;
        this.minY = miny;
        this.maxY = maxy;
        this.cellsize = cellsize;
        Raster.setCellSize(this.cellsize);
    }

    public JaiMatrix3(double cellsize, double minx, double maxx, double miny, double maxy, PlanarImage pi, boolean read) {
        this(pi, read);
        this.minX = minx;
        this.maxX = maxx;
        this.minY = miny;
        this.maxY = maxy;
        this.cellsize = cellsize;
        Raster.setCellSize(this.cellsize);
    }

    public JaiMatrix3(double cellsize, double minx, double maxx, double miny, double maxy, PlanarImage pi, Set<Integer> values) {
        this(pi, values);
        this.minX = minx;
        this.maxX = maxx;
        this.minY = miny;
        this.maxY = maxy;
        this.cellsize = cellsize;
        Raster.setCellSize(this.cellsize);
    }

    public String toString() {
        return this.file;
    }

    @Override
    public Iterator<Pixel> iterator() {
        return new TiledMatrixIterator(this.pi);
    }

    private void initValues() {
        this.values = new HashSet<Integer>();
        RectIter ite = RectIterFactory.create((RenderedImage)this.pi, (Rectangle)new Rectangle(0, 0, this.pi.getWidth(), this.pi.getHeight()));
        this.minV = 2.147483647E9;
        this.maxV = -2.147483648E9;
        int line = 0;
        while (true) {
            double v;
            if ((v = ite.getSampleDouble()) != (double)Raster.getNoDataValue()) {
                this.minV = Math.min(this.minV, v);
                this.maxV = Math.max(this.maxV, v);
            }
            this.values.add((int)v);
            if (!ite.nextPixelDone()) continue;
            ite.startPixels();
            System.out.println(line++ + "/" + this.height());
            if (ite.nextLineDone()) break;
        }
    }

    @Override
    public double get(int x, int y) {
        if (x >= 0 && x < this.width() && y >= 0 && y < this.height()) {
            return this.ite.getPixel(x, y, this.pixel)[0];
        }
        return Raster.getNoDataValue();
    }

    @Override
    public double get(Pixel p) {
        return this.get(p.x(), p.y());
    }

    @Override
    public void put(int x, int y, double value) {
        this.pixel[0] = value;
        ((TiledImage)this.pi).getWritableTile(x / this.tileWidth(), y / this.tileHeight()).setPixel(x, y, this.pixel);
    }

    @Override
    public void put(Pixel p, double value) {
        this.put(p.x(), p.y(), value);
    }

    private void put(int x, int y, double[] value) {
        ((TiledImage)this.pi).getWritableTile(x / this.tileWidth(), y / this.tileHeight()).setPixel(x, y, value);
    }

    @Override
    public void put(Raster r, double value) {
        this.pixel[0] = value;
        for (Pixel p : r) {
            this.put(p.x(), p.y(), this.pixel);
        }
    }

    @Override
    public void init(double v) {
        for (int yt = 0; yt < this.pi.getNumYTiles(); ++yt) {
            for (int xt = 0; xt < this.pi.getNumXTiles(); ++xt) {
                WritableRaster wraster = ((TiledImage)this.pi).getWritableTile(xt, yt);
                double[] pixels = new double[this.pi.getTileWidth() * this.pi.getTileHeight()];
                for (int y = 0; y < this.pi.getTileHeight() && y + yt * this.pi.getTileHeight() < this.height(); ++y) {
                    for (int x = 0; x < this.pi.getTileWidth() && x + xt * this.pi.getTileWidth() < this.width(); ++x) {
                        int index = x + y * this.pi.getTileWidth();
                        pixels[index] = v;
                    }
                }
                wraster.setPixels(xt * this.pi.getTileWidth(), yt * this.pi.getTileHeight(), this.pi.getTileWidth(), this.pi.getTileHeight(), pixels);
            }
        }
        this.values.clear();
        this.values.add(new Double(v).intValue());
    }

    @Override
    public int height() {
        return this.pi.getHeight();
    }

    @Override
    public int width() {
        return this.pi.getWidth();
    }

    @Override
    public double minX() {
        return this.minX;
    }

    @Override
    public double maxX() {
        return this.maxX;
    }

    @Override
    public double minY() {
        return this.minY;
    }

    @Override
    public double maxY() {
        return this.maxY;
    }

    @Override
    public double cellsize() {
        return this.cellsize;
    }

    @Override
    public int noDataValue() {
        return Raster.getNoDataValue();
    }

    @Override
    public void display() {
        for (int yt = 0; yt < this.pi.getNumYTiles(); ++yt) {
            for (int xt = 0; xt < this.pi.getNumXTiles(); ++xt) {
                for (int y = yt * this.pi.getTileHeight(); y < (yt + 1) * this.pi.getTileHeight() && y < this.height(); ++y) {
                    for (int x = xt * this.pi.getTileWidth(); x < (xt + 1) * this.pi.getTileWidth() && x < this.width(); ++x) {
                        System.out.println(x + " " + y + " " + this.get(x, y));
                    }
                }
            }
        }
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public void setFile(String file) {
        this.file = file;
    }

    @Override
    public Set<Integer> values() {
        return this.values;
    }

    @Override
    public void visualize() {
        String imageInfo = "Dimensions: " + this.width() + "x" + this.height() + " Bands:" + this.pi.getNumBands();
        JFrame frame = new JFrame();
        frame.setTitle("DisplayJAI: ");
        Container contentPane = frame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        DisplayJAI dj = new DisplayJAI((RenderedImage)this.pi);
        contentPane.add((Component)new JScrollPane((Component)dj), "Center");
        contentPane.add((Component)new JLabel(imageInfo), "South");
        frame.setDefaultCloseOperation(3);
        frame.setSize(300, 400);
        frame.setVisible(true);
    }

    @Override
    public MatrixType getType() {
        return MatrixType.JAI;
    }

    @Override
    public double getActiveArea() {
        double area = 0.0;
        double pow = Math.pow(this.cellsize, 2.0);
        for (int yt = 0; yt < this.pi.getNumYTiles(); ++yt) {
            for (int xt = 0; xt < this.pi.getNumXTiles(); ++xt) {
                for (int y = yt * this.pi.getTileHeight(); y < (yt + 1) * this.pi.getTileHeight() && y < this.height(); ++y) {
                    for (int x = xt * this.pi.getTileWidth(); x < (xt + 1) * this.pi.getTileWidth() && x < this.width(); ++x) {
                        if (this.get(x, y) == (double)Raster.getNoDataValue()) continue;
                        area += pow;
                    }
                }
            }
        }
        return area;
    }

    @Override
    public void getCouples(Matrix horizontals, Matrix verticals) {
        for (Pixel p : this) {
            if (p.x() < this.width()) {
                horizontals.put(p.x(), p.y(), Couple.get(this.get(p.x(), p.y()), this.get(p.x() + 1, p.y())));
            }
            if (p.y() >= this.height()) continue;
            verticals.put(p.x(), p.y(), Couple.get(this.get(p.x(), p.y()), this.get(p.x(), p.y() + 1)));
        }
        for (int yt = 0; yt < this.pi.getNumYTiles(); ++yt) {
            for (int xt = 0; xt < this.pi.getNumXTiles(); ++xt) {
                int y;
                for (y = yt * this.pi.getTileHeight(); y < (yt + 1) * this.pi.getTileHeight() && y < this.height(); ++y) {
                    for (int x = xt * this.pi.getTileWidth(); x < (xt + 1) * this.pi.getTileWidth() && x < this.width(); ++x) {
                        verticals.put(x, y, Couple.get(this.get(x, y), this.get(x, y + 1)));
                        horizontals.put(x, y, Couple.get(this.get(x, y), this.get(x + 1, y)));
                    }
                }
                for (y = yt * this.pi.getTileHeight(); y < (yt + 1) * this.pi.getTileHeight() && y < this.height(); ++y) {
                    verticals.put(this.width() - 1, y, Couple.get(this.get(this.width() - 1, y), this.get(this.width() - 1, y + 1)));
                }
                for (int x = 0; x < this.width() - 1; ++x) {
                    horizontals.put(x, this.height() - 1, Couple.get(this.get(x, this.height() - 1), this.get(x + 1, this.height() - 1)));
                }
            }
        }
    }

    @Override
    public boolean contains(Pixel p) {
        return this.contains(p.x(), p.y());
    }

    @Override
    public boolean contains(int x, int y) {
        return x >= 0 && x < this.width() && y >= 0 && y < this.height();
    }

    @Override
    public int tileWidth() {
        return this.pi.getTileWidth();
    }

    @Override
    public int tileHeight() {
        return this.pi.getTileHeight();
    }

    @Override
    public int numXTiles() {
        return this.pi.getNumXTiles();
    }

    @Override
    public int numYTiles() {
        return this.pi.getNumYTiles();
    }

    @Override
    public double minV() {
        return this.minV;
    }

    @Override
    public double maxV() {
        return this.maxV;
    }
}

