/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Puntal;
import com.vividsolutions.jts.geom.prep.PreparedPoint;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileReader;

public class DirectExport {
    private static String s = "/home/sad20/temp/laurence/buffer.shp";
    private static String a = "/home/sad20/temp/laurence/buffer2.asc";

    public static void main(String[] args) {
        DirectExport.shapeFile2Ascii(s, "test", a, 50.0);
    }

    public static void shapeFile2Ascii(String shape, String attName, String ascii, double cellsize) {
        try {
            ShpFiles sf = shape.endsWith(".shp") ? new ShpFiles(shape) : new ShpFiles(shape + ".shp");
            ShapefileReader sfr = new ShapefileReader(sf, true, true, new GeometryFactory());
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            DbaseFileHeader dfh = dfr.getHeader();
            int attPos = -1;
            for (int i = 0; i < dfh.getNumFields(); ++i) {
                if (!dfh.getFieldName(i).equalsIgnoreCase(attName)) continue;
                attPos = i;
                break;
            }
            double minX = 9.99999999E8;
            double minY = 9.99999999E8;
            double maxX = -9.99999999E8;
            double maxY = -9.99999999E8;
            HashSet<Polygon> polys = new HashSet<Polygon>();
            Object[] entry = new Object[12];
            while (sfr.hasNext()) {
                MultiPolygon mp = (MultiPolygon)sfr.nextRecord().shape();
                minX = Math.min(minX, mp.getEnvelopeInternal().getMinX());
                minY = Math.min(minY, mp.getEnvelopeInternal().getMinY());
                maxX = Math.max(maxX, mp.getEnvelopeInternal().getMaxX());
                maxY = Math.max(maxY, mp.getEnvelopeInternal().getMaxY());
                long value = (entry = dfr.readEntry(entry))[attPos] instanceof Long ? (Long)entry[attPos] : (long)((Integer)entry[attPos]).intValue();
                for (int i = 0; i < mp.getNumGeometries(); ++i) {
                    Polygon poly = (Polygon)mp.getGeometryN(i);
                    poly.setUserData((Object)value);
                    polys.add(poly);
                }
            }
            int ncols = new Double((maxX - minX) / cellsize).intValue();
            int nrows = new Double((maxY - minY) / cellsize).intValue();
            PreparedPoint p = null;
            List l = null;
            Polygon ftemp = null;
            long vtemp = -1L;
            int modulo = 1;
            WKTReader r = new WKTReader();
            STRtree sIndex = new STRtree();
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(ascii));
                bw.write("ncols " + ncols);
                bw.newLine();
                bw.write("nrows " + nrows);
                bw.newLine();
                bw.write("xllcorner " + minX);
                bw.newLine();
                bw.write("yllcorner " + minY);
                bw.newLine();
                bw.write("cellsize " + cellsize);
                bw.newLine();
                bw.write("NODATA_value -1");
                bw.newLine();
                for (Polygon po : polys) {
                    sIndex.insert(po.getEnvelopeInternal(), (Object)po);
                }
                sIndex.build();
                for (int j = 0; j < nrows; ++j) {
                    double x = minX;
                    double y = maxY - (double)j * cellsize;
                    if (j % modulo == 0) {
                        Envelope env = new Envelope(new Coordinate(x, y), new Coordinate(maxX, y - (double)modulo * cellsize));
                        l = sIndex.query(env);
                    }
                    int index = 0;
                    for (int i = 0; i < ncols; ++i) {
                        x = minX + (double)i * cellsize;
                        boolean ok = false;
                        try {
                            p = new PreparedPoint((Puntal)r.read("POINT (" + x + " " + y + ")"));
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        if (ftemp != null && p.intersects(ftemp)) {
                            bw.write(vtemp + " ");
                            ok = true;
                        }
                        if (!ok) {
                            for (Polygon pol : l) {
                                if (!p.intersects((Geometry)pol)) continue;
                                vtemp = (Long)pol.getUserData();
                                ftemp = pol;
                                bw.write(vtemp + " ");
                                ok = true;
                                break;
                            }
                        }
                        if (!ok) {
                            bw.write("-1 ");
                        }
                        ++index;
                    }
                    bw.newLine();
                    System.out.println(j + " " + index);
                }
                bw.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            sfr.close();
            dfr.close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (ShapefileException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void addNoDataValueInAFolder(String input, String output, int noDataValue) {
        File finput;
        File foutput = new File(output);
        if (!foutput.exists()) {
            foutput.mkdir();
        }
        if ((finput = new File(input)).isDirectory()) {
            for (File f : finput.listFiles()) {
                if (!f.isFile() || !f.getName().endsWith(".asc")) continue;
                DirectExport.addNoDataValueIfNeeded(input + f.getName(), output + f.getName(), noDataValue);
            }
        }
    }

    public static void addNoDataValueIfNeeded(String in, String out, int noDataValue) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(in));
            BufferedWriter bw = new BufferedWriter(new FileWriter(out));
            bw.write(br.readLine());
            bw.newLine();
            bw.write(br.readLine());
            bw.newLine();
            bw.write(br.readLine());
            bw.newLine();
            bw.write(br.readLine());
            bw.newLine();
            bw.write(br.readLine());
            bw.newLine();
            String nodata = br.readLine();
            if (!nodata.startsWith("NODATA_value")) {
                bw.write("NODATA_value " + noDataValue);
                bw.newLine();
            }
            String line = nodata;
            while (line != null) {
                bw.write(line);
                bw.newLine();
                line = br.readLine();
            }
            br.close();
            bw.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

