/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix;

import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.IteratorMatrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixManager;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixType;
import fr.inra.sad.bagap.apiland.core.util.Couple;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ArrayMatrix
implements Matrix,
Iterable<Pixel> {
    private static final long serialVersionUID = 1L;
    private double[][] tab;
    private int height;
    private int width;
    private double minX;
    private double maxY;
    private double minY;
    private double maxX;
    private int noDataValue;
    private double cellsize;
    private String file;
    private Set<Integer> values;

    public ArrayMatrix(double[][] tab) {
        this.tab = tab;
        this.height = tab.length;
        this.width = tab[0].length;
    }

    public ArrayMatrix(int width, int height) {
        this.height = height;
        this.width = width;
        this.tab = new double[height][width];
        this.values = new HashSet<Integer>();
    }

    public ArrayMatrix(int width, int height, double cellsize, double minX, double maxX, double minY, double maxY, int noDataValue) {
        this.height = height;
        this.width = width;
        this.cellsize = cellsize;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.noDataValue = noDataValue;
        this.tab = new double[height][width];
        this.values = new HashSet<Integer>();
    }

    public ArrayMatrix(int width, int height, double cellsize, double minX, double maxX, double minY, double maxY, int noDataValue, double[][] tab, Set<Integer> values, String file) {
        this(width, height, cellsize, minX, maxX, minY, maxY, noDataValue);
        this.tab = tab;
        this.values = values;
        this.file = file;
    }

    public ArrayMatrix(Matrix matrix) {
        this.height = matrix.height();
        this.width = matrix.width();
        this.cellsize = matrix.cellsize();
        this.minX = matrix.minX();
        this.maxX = matrix.maxX();
        this.minY = matrix.minY();
        this.maxY = matrix.maxY();
        this.noDataValue = matrix.noDataValue();
        this.tab = new double[this.height][this.width];
        this.values = new HashSet<Integer>();
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public void setFile(String file) {
        this.file = file;
    }

    @Override
    public void display() {
        System.out.println();
        System.out.println(this);
        System.out.println("area = " + this.getActiveArea());
        double[][] dArray = this.tab;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] t;
            for (double d : t = dArray[i]) {
                System.out.print(d + " ");
            }
            System.out.println();
        }
    }

    @Override
    public void init(double v) {
        for (double[] t : this.tab) {
            for (int i = 0; i < t.length; ++i) {
                t[i] = v;
            }
        }
    }

    @Override
    public double get(int x, int y) {
        try {
            return this.tab[y][x];
        }
        catch (Exception ex) {
            return this.noDataValue;
        }
    }

    @Override
    public double get(Pixel p) {
        return this.get(p.x(), p.y());
    }

    @Override
    public void put(int x, int y, double value) {
        this.tab[y][x] = value;
        if (value != (double)this.noDataValue) {
            this.values.add(new Double(value).intValue());
        }
    }

    @Override
    public void put(Pixel p, double value) {
        this.put(p.x(), p.y(), value);
    }

    @Override
    public void put(Raster r, double value) {
        for (Pixel p : r) {
            this.put(p, value);
        }
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public Iterator<Pixel> iterator() {
        return new IteratorMatrix(this);
    }

    @Override
    public double getActiveArea() {
        double area = 0.0;
        double pow = Math.pow(this.cellsize, 2.0);
        for (Pixel p : this) {
            if (this.get(p) == (double)this.noDataValue) continue;
            area += pow;
        }
        return area;
    }

    @Override
    public double cellsize() {
        return this.cellsize;
    }

    @Override
    public double maxY() {
        return this.maxY;
    }

    @Override
    public double minX() {
        return this.minX;
    }

    @Override
    public double maxX() {
        return this.maxX;
    }

    @Override
    public double minY() {
        return this.minY;
    }

    @Override
    public int noDataValue() {
        return this.noDataValue;
    }

    @Override
    public Set<Integer> values() {
        return this.values;
    }

    @Override
    public void visualize() {
        MatrixManager.visualize(this);
    }

    @Override
    public MatrixType getType() {
        return MatrixType.ARRAY;
    }

    @Override
    public void getCouples(Matrix horizontals, Matrix verticals) {
        int y;
        for (y = 0; y < this.height() - 1; ++y) {
            for (int x = 0; x < this.width() - 1; ++x) {
                verticals.put(x, y, Couple.get(new Double(this.get(x, y)).intValue(), new Double(this.get(x, y + 1)).intValue()));
                horizontals.put(x, y, Couple.get(new Double(this.get(x, y)).intValue(), new Double(this.get(x + 1, y)).intValue()));
            }
        }
        for (y = 0; y < this.height() - 1; ++y) {
            verticals.put(this.width() - 1, y, Couple.get(new Double(this.get(this.width() - 1, y)).intValue(), new Double(this.get(this.width() - 1, y + 1)).intValue()));
        }
        for (int x = 0; x < this.width() - 1; ++x) {
            horizontals.put(x, this.height() - 1, Couple.get(new Double(this.get(x, this.height() - 1)).intValue(), new Double(this.get(x + 1, this.height() - 1)).intValue()));
        }
    }

    @Override
    public int tileWidth() {
        return this.width();
    }

    @Override
    public int tileHeight() {
        return this.height();
    }

    @Override
    public int numXTiles() {
        return 1;
    }

    @Override
    public int numYTiles() {
        return 1;
    }

    @Override
    public boolean contains(int x, int y) {
        return x >= 0 && x < this.width() && y >= 0 && y < this.height();
    }

    @Override
    public boolean contains(Pixel p) {
        return this.contains(p.x(), p.y());
    }

    @Override
    public double minV() {
        double min = Double.MAX_VALUE;
        for (double[] t : this.tab) {
            for (int i = 0; i < t.length; ++i) {
                min = Math.min(min, t[i]);
            }
        }
        return min;
    }

    @Override
    public double maxV() {
        double max = Double.MIN_VALUE;
        for (double[] t : this.tab) {
            for (int i = 0; i < t.length; ++i) {
                max = Math.max(max, t[i]);
            }
        }
        return max;
    }
}

