/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.space.impl.raster;

import fr.inra.sad.bagap.apiland.core.space.impl.GeometryImpl;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.BoundaryIterator;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.MarginIterator;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.PixelIterator;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.RasterComposite;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class PixelComposite
extends Raster
implements Iterable<Pixel> {
    private static final long serialVersionUID = 1L;
    private int value;
    private Set<Pixel> pixels = new HashSet<Pixel>();
    private Set<Pixel> bounds;

    public PixelComposite() {
        this.smooth = true;
    }

    public PixelComposite(Set<Pixel> pixels) {
        this.addAll(pixels);
        this.smooth = true;
    }

    public PixelComposite(Pixel pixel) {
        this.add(pixel);
        this.smooth = true;
    }

    public PixelComposite(Pixel pixel, int value) {
        this(pixel);
        this.value = value;
    }

    public PixelComposite(Pixel pixel, int value, Number userObject) {
        this(pixel, value);
        this.setUserData(userObject.doubleValue());
    }

    public int getValue() {
        return this.value;
    }

    public void clear() {
        this.pixels.clear();
        this.smooth = true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        for (Pixel p : this) {
            sb.append(p.toString() + ";");
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public PixelComposite clone() {
        PixelComposite clone = (PixelComposite)super.clone();
        clone.pixels = new HashSet<Pixel>();
        for (Pixel p : this.pixels) {
            clone.pixels.add(p.clone());
        }
        return clone;
    }

    public void addSimplePixel(Pixel p) {
        this.pixels.add(p);
    }

    protected void add(Raster r) {
        for (Pixel p : r) {
            this.pixels.add(p);
        }
        this.smooth = false;
    }

    protected void addAll(Collection<? extends Raster> c) {
        for (Raster raster : c) {
            for (Pixel p : raster) {
                this.pixels.add(p);
            }
        }
        this.smooth = false;
    }

    @Override
    public boolean isSmooth() {
        return this.smooth;
    }

    @Override
    public Raster smooth() {
        if (!this.smooth) {
            if (this.pixels.size() > 0) {
                if (this.pixels.size() == 1) {
                    return this.pixels.iterator().next().smooth();
                }
                HashSet<Pixel> pixelss = new HashSet<Pixel>();
                for (Pixel p : this) {
                    pixelss.add(p);
                }
                this.pixels = pixelss;
                if (this.pixels.size() == 1) {
                    return this.pixels.iterator().next();
                }
            }
            this.smooth = true;
        }
        return this;
    }

    public Set<Pixel> getPixels() {
        return this.pixels;
    }

    @Override
    public Iterator<Pixel> iterator() {
        return new PixelIterator(this.pixels.iterator());
    }

    @Override
    public Iterator<Pixel> getBoundaries() {
        return new BoundaryIterator(this);
    }

    public Set<Pixel> getBounds() {
        if (this.bounds == null) {
            this.bounds = new HashSet<Pixel>();
            block0: for (Pixel p : this) {
                Iterator<Pixel> ite = p.getMargins();
                while (ite.hasNext()) {
                    Pixel p2 = ite.next();
                    if (this.pixels.contains(p2)) continue;
                    this.bounds.add(p);
                    continue block0;
                }
            }
        }
        return this.bounds;
    }

    @Override
    public Iterator<Pixel> getMargins() {
        return new MarginIterator(this);
    }

    @Override
    public int count() {
        if (!this.smooth) {
            Raster r = this.smooth();
            return r.count();
        }
        return this.pixels.size();
    }

    @Override
    public int size() {
        int s = 0;
        for (Pixel p : this.pixels) {
            s += p.size();
        }
        return s;
    }

    @Override
    public double getArea() {
        return (double)this.count() * Math.pow(size, 2.0);
    }

    @Override
    public double getLength() {
        Iterator<Pixel> ite = this.getBoundaries();
        double length = 0.0;
        while (ite.hasNext()) {
            ite.next();
            length += size;
        }
        return length;
    }

    @Override
    public boolean equals(GeometryImpl impl) {
        try {
            return ((Raster)impl).equalsPixelComposite(this);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    protected boolean equalsPixel(Pixel impl) {
        for (Pixel p : this) {
            if (p.equalsPixel(impl)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean equalsPixelComposite(PixelComposite impl) {
        if (this.getArea() == impl.getArea()) {
            for (Pixel p : this) {
                if (impl.containsPixel(p)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean equalsRasterComposite(RasterComposite impl) {
        return impl.equalsPixelComposite(this);
    }

    @Override
    public boolean contains(GeometryImpl impl) {
        try {
            return ((Raster)impl).withinPixelComposite(this);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public boolean containsPixel(Pixel impl) {
        for (Pixel p : this) {
            if (!p.equalsPixel(impl)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean containsPixelComposite(PixelComposite impl) {
        for (Pixel p : impl) {
            if (this.containsPixel(p)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean containsRasterComposite(RasterComposite impl) {
        return impl.withinPixelComposite(this);
    }

    @Override
    public boolean crosses(GeometryImpl impl) {
        try {
            return ((Raster)impl).crossesPixelComposite(this);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    protected boolean crossesPixel(Pixel impl) {
        return false;
    }

    @Override
    protected boolean crossesPixelComposite(PixelComposite impl) {
        Iterator<Pixel> ite = this.iterator();
        if (ite.hasNext()) {
            Pixel p = ite.next();
            if (impl.containsPixel(p)) {
                while (ite.hasNext()) {
                    p = ite.next();
                    if (impl.containsPixel(p)) continue;
                    return true;
                }
                return false;
            }
            while (ite.hasNext()) {
                p = ite.next();
                if (!impl.containsPixel(p)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    protected boolean crossesRasterComposite(RasterComposite impl) {
        return impl.crossesPixelComposite(this);
    }

    @Override
    public boolean touches(GeometryImpl impl) {
        try {
            return ((Raster)impl).touchesPixelComposite(this);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    protected boolean touchesPixel(Pixel impl) {
        boolean touche = false;
        for (Pixel p : this) {
            if (p.equals(impl)) {
                return false;
            }
            if (!p.touchesPixel(impl)) continue;
            touche = true;
        }
        return touche;
    }

    @Override
    protected boolean touchesPixelWithoutContainsTest(Pixel impl) {
        for (Pixel p : this) {
            if (!p.touchesPixel(impl)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean touchesPixelComposite(PixelComposite impl) {
        if (this.disjointPixelComposite(impl)) {
            for (Pixel p : this) {
                if (!impl.touchesPixel(p)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean touchesPixelCompositeWithoutDisjointTest(PixelComposite impl) {
        for (Pixel p : this) {
            if (!impl.touchesPixelWithoutContainsTest(p)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean touchesRasterComposite(RasterComposite impl) {
        return impl.touchesPixelComposite(this);
    }

    @Override
    public boolean within(GeometryImpl impl) {
        try {
            return ((Raster)impl).containsPixelComposite(this);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    protected boolean withinPixel(Pixel impl) {
        for (Pixel p : this) {
            if (impl.equalsPixel(p)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean withinPixelComposite(PixelComposite impl) {
        for (Pixel p : this) {
            if (impl.containsPixel(p)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean withinRasterComposite(RasterComposite impl) {
        return impl.containsPixelComposite(this);
    }

    @Override
    public boolean intersects(GeometryImpl impl) {
        try {
            return ((Raster)impl).intersectsPixelComposite(this);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    protected boolean intersectsPixel(Pixel impl) {
        return this.containsPixel(impl);
    }

    @Override
    protected boolean intersectsPixelComposite(PixelComposite impl) {
        for (Pixel p : this) {
            if (!impl.containsPixel(p)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean intersectsRasterComposite(RasterComposite impl) {
        return impl.intersectsPixelComposite(this);
    }

    @Override
    public boolean disjoint(GeometryImpl impl) {
        try {
            return ((Raster)impl).disjointPixelComposite(this);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    protected boolean disjointPixel(Pixel impl) {
        return !this.containsPixel(impl);
    }

    @Override
    protected boolean disjointPixelComposite(PixelComposite impl) {
        for (Pixel p : this) {
            if (!impl.containsPixel(p)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean disjointRasterComposite(RasterComposite impl) {
        return impl.disjointPixelComposite(this);
    }

    @Override
    public boolean overlaps(GeometryImpl impl) {
        try {
            return ((Raster)impl).overlapsPixelComposite(this);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    protected boolean overlapsPixel(Pixel impl) {
        for (Pixel p : this) {
            if (impl.equalsPixel(p)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean overlapsPixelComposite(PixelComposite impl) {
        return false;
    }

    @Override
    protected boolean overlapsRasterComposite(RasterComposite impl) {
        return impl.overlapsPixelComposite(this);
    }

    @Override
    public Raster addGeometryImpl(GeometryImpl impl) {
        try {
            return ((Raster)impl).addPixelComposite(this);
        }
        catch (Exception ex) {
            return this;
        }
    }

    @Override
    protected Raster addPixel(Pixel impl) {
        if (this.count() == 0) {
            return impl;
        }
        if (this.containsPixel(impl)) {
            return this;
        }
        if (this.touchesPixelWithoutContainsTest(impl)) {
            this.add(impl);
            this.smooth = true;
            return this;
        }
        RasterComposite rc = new RasterComposite();
        rc.add(this);
        rc.add(impl);
        rc.setSmooth(true);
        return rc;
    }

    @Override
    protected Raster addPixelComposite(PixelComposite impl) {
        if (this.count() == 0) {
            return impl;
        }
        if (impl.count() == 0) {
            return this;
        }
        if (this.intersectsPixelComposite(impl)) {
            if (this.containsPixelComposite(impl)) {
                return this;
            }
            if (this.withinPixelComposite(impl)) {
                return impl;
            }
            this.add(impl);
            return this.smooth();
        }
        if (this.touchesPixelCompositeWithoutDisjointTest(impl)) {
            this.add(impl);
            return this.smooth();
        }
        RasterComposite rc = new RasterComposite();
        rc.add(this);
        rc.add(impl);
        rc.smooth = true;
        return rc;
    }

    @Override
    protected Raster addRasterComposite(RasterComposite impl) {
        return impl.addPixelComposite(this);
    }

    @Override
    public double minX() {
        double min = 9.99999999E8;
        for (Pixel p : this) {
            min = Math.min(min, p.minX());
        }
        return min;
    }

    @Override
    public double maxX() {
        double max = -9.99999999E8;
        for (Pixel p : this) {
            max = Math.max(max, p.maxX());
        }
        return max;
    }

    @Override
    public double minY() {
        double min = 9.99999999E8;
        for (Pixel p : this) {
            min = Math.min(min, p.minY());
        }
        return min;
    }

    @Override
    public double maxY() {
        double max = -9.99999999E8;
        for (Pixel p : this) {
            max = Math.max(max, p.maxY());
        }
        return max;
    }

    @Override
    public Pixel getOne() {
        return this.pixels.iterator().next();
    }
}

