/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.simul.output;

import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverManager;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.capfarm.simul.CoverLocationModel;
import fr.inra.sad.bagap.apiland.capfarm.simul.GlobalCoverLocationModel;
import fr.inra.sad.bagap.apiland.core.element.manager.DynamicElementFactory;
import fr.inra.sad.bagap.apiland.core.element.manager.DynamicLayerFactory;
import fr.inra.sad.bagap.apiland.core.element.type.DynamicElementTypeFactory;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.simul.OutputAnalysis;
import fr.inra.sad.bagap.apiland.simul.Scenario;
import fr.inra.sad.bagap.apiland.simul.Simulation;
import java.util.HashMap;
import java.util.Map;

public class ShapefileByScenarioOutput
extends OutputAnalysis {
    private Map<Parcel, Map<CoverUnit, Integer>> count;

    @Override
    public void init(Scenario scenario) {
        this.count = new HashMap<Parcel, Map<CoverUnit, Integer>>();
        for (CoverLocationModel model : (GlobalCoverLocationModel)scenario.model().get("agriculture")) {
            for (Parcel p : model.getCoverAllocator().parcels()) {
                this.count.put(p, new HashMap());
                for (CoverUnit c : CoverManager.coverUnits()) {
                    p.getType().addAttributeType(DynamicElementTypeFactory.createAttributeType("nb_" + c.getCode(), null, Integer.class));
                    p.getComposition().addAttribute(DynamicElementFactory.createAttribute(p.getType().getAttributeType("nb_" + c.getCode())));
                    this.count.get(p).put(c, 0);
                }
            }
        }
    }

    @Override
    public void close(Simulation simulation) {
        if (!simulation.isCancelled()) {
            for (CoverLocationModel model : (GlobalCoverLocationModel)simulation.model().get("agriculture")) {
                for (Parcel p : model.getCoverAllocator().parcels()) {
                    Instant t = simulation.manager().start();
                    while (t.isBefore(simulation.manager().end()) || t.equals(simulation.manager().end())) {
                        CoverUnit cu = (CoverUnit)p.getAttribute("cover").getValue(t);
                        this.count.get(p).put(cu, this.count.get(p).get(cu) + 1);
                        t = simulation.manager().delay().next(t);
                    }
                }
            }
        }
    }

    @Override
    public void close(Scenario scenario) {
        for (CoverLocationModel model : (GlobalCoverLocationModel)scenario.model().get("agriculture")) {
            for (Parcel p : model.getCoverAllocator().parcels()) {
                for (CoverUnit coverUnit : CoverManager.coverUnits()) {
                    p.getAttribute("nb_" + coverUnit.getCode()).setValue(scenario.manager().start(), this.count.get(p).get(coverUnit));
                }
            }
            DynamicLayerFactory.exportShape(model.getCoverAllocator().getTerritory(), scenario.manager().start(), scenario.folder() + "count_cover_by_scenario");
        }
        for (CoverLocationModel model : (GlobalCoverLocationModel)scenario.model().get("agriculture")) {
            for (Parcel p : model.getCoverAllocator().parcels()) {
                for (Cover cover : CoverManager.coverUnits()) {
                    p.getComposition().removeAttribute("nb_" + cover.getCode());
                }
            }
        }
        for (CoverLocationModel model : (GlobalCoverLocationModel)scenario.model().get("agriculture")) {
            for (Parcel p : model.getCoverAllocator().parcels()) {
                for (Cover cover : CoverManager.coverUnits()) {
                    p.getType().removeAttributeType("nb_" + cover.getCode());
                }
            }
        }
    }
}

