/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.simul;

import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.Farm;
import fr.inra.sad.bagap.apiland.capfarm.model.FixedFactory;
import fr.inra.sad.bagap.apiland.capfarm.model.HistoricFactory;
import fr.inra.sad.bagap.apiland.capfarm.model.MemoryFactory;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.capfarm.simul.CfmManager;
import fr.inra.sad.bagap.apiland.capfarm.simul.CoverLocationModel;
import fr.inra.sad.bagap.apiland.capfarm.simul.GlobalCoverLocationModel;
import fr.inra.sad.bagap.apiland.core.composition.DynamicAttribute;
import fr.inra.sad.bagap.apiland.core.composition.TemporalValue;
import fr.inra.sad.bagap.apiland.core.time.Future;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.Interval;
import fr.inra.sad.bagap.apiland.simul.Scenario;
import fr.inra.sad.bagap.apiland.simul.Simulation;
import java.io.File;
import java.io.Serializable;

public class CfmSimulation
extends Simulation {
    private static final long serialVersionUID = 1L;

    public CfmSimulation(Scenario scenario, int number) {
        super(scenario, number);
    }

    @Override
    protected void initModel() {
        for (CoverLocationModel model : (GlobalCoverLocationModel)this.model().get("agriculture")) {
            model.getCoverAllocator().clearParcels();
            MemoryFactory.init(model, this.manager().start(), this.manager().paramProcessMode(), this.manager().methodProcessMode());
            HistoricFactory.init((Farm)model.getCoverAllocator(), this.manager().start());
            FixedFactory.init((Farm)model.getCoverAllocator(), this.manager().start());
        }
    }

    @Override
    public CfmManager manager() {
        return (CfmManager)super.manager();
    }

    @Override
    protected void close() {
        this.closeSequences();
        super.close();
        if (!this.isCancelled() && this.manager().checkConstraints()) {
            for (CoverLocationModel model : (GlobalCoverLocationModel)this.model().get("agriculture")) {
                model.getCoverAllocator().checkFarmingSystem(this.manager().start(), this.manager().end(), true);
            }
        }
        if (this.isCancelled()) {
            new File(this.folder()).delete();
        }
    }

    public void closeSequences() {
        if (!this.isCancelled()) {
            String strict_seq = "";
            String seq_cover = "";
            String seq_year = "";
            int length = 0;
            CoverUnit last = null;
            Interval interval = new Interval(this.manager().start(), this.manager().end());
            for (CoverLocationModel model : (GlobalCoverLocationModel)this.model().get("agriculture")) {
                for (Parcel p : model.getCoverAllocator().parcels()) {
                    StringBuilder sb_cover = new StringBuilder();
                    for (TemporalValue tv : ((DynamicAttribute)p.getAttribute("cover")).getDynamics()) {
                        last = (CoverUnit)tv.getValue();
                        length = tv.getTime().end() instanceof Future ? this.manager().end().year() + 1 - tv.getTime().start().year() : tv.getTime().end().year() - tv.getTime().start().year();
                        if (!tv.getTime().intersects(interval)) continue;
                        if (length > 1) {
                            sb_cover.append(tv.getValue() + "(" + length + ") - ");
                            continue;
                        }
                        sb_cover.append(tv.getValue() + " - ");
                    }
                    sb_cover.delete(sb_cover.length() - 3, sb_cover.length());
                    seq_cover = sb_cover.toString();
                    sb_cover = new StringBuilder();
                    for (TemporalValue tv : ((DynamicAttribute)p.getAttribute("cover")).getDynamics().cut(this.manager().start(), this.manager().end())) {
                        last = (CoverUnit)tv.getValue();
                        length = tv.getTime().end() instanceof Future ? this.manager().end().year() + 1 - tv.getTime().start().year() : tv.getTime().end().year() - tv.getTime().start().year();
                        if (length > 1) {
                            sb_cover.append(tv.getValue() + "(" + length + ") - ");
                            continue;
                        }
                        sb_cover.append(tv.getValue() + " - ");
                    }
                    sb_cover.delete(sb_cover.length() - 3, sb_cover.length());
                    strict_seq = sb_cover.toString();
                    StringBuilder sb_year = new StringBuilder();
                    Instant t = this.manager().start();
                    while (t.isBefore(this.manager().end()) || t.equals(this.manager().end())) {
                        sb_year.append(p.getAttribute("cover").getValue(t) + " - ");
                        t = this.manager().delay().next(t);
                    }
                    sb_year.delete(sb_year.length() - 3, sb_year.length());
                    seq_year = sb_year.toString();
                    p.getAttribute("strict_seq").setValue(null, (Serializable)((Object)strict_seq));
                    p.getAttribute("seq_cover").setValue(null, (Serializable)((Object)seq_cover));
                    p.getAttribute("seq_year").setValue(null, (Serializable)((Object)seq_year));
                    p.getAttribute("length").setValue(null, Integer.valueOf(length));
                    p.getAttribute("repet").setValue(null, Integer.valueOf(((DynamicAttribute)p.getAttribute("cover")).getCountOfLastValue(last)));
                }
            }
        }
    }
}

