/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.economic.constraint;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintMode;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintType;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.CoverAllocationConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.domain.Domain;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.ManagmentProfil;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.csp.EconomicCoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.delay.Delay;
import fr.inra.sad.bagap.apiland.core.time.delay.YearDelay;
import java.util.Set;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.VF;

public class WorkConstraint
extends CoverAllocationConstraint<Integer, Integer> {
    private static final long serialVersionUID = 1L;
    private ManagmentProfil mp;

    public WorkConstraint(String code, boolean checkOnly, ConstraintMode mode, Set<Cover> covers, Set<Parcel> parcels, Domain<Integer, Integer> domain) {
        super(code, checkOnly, ConstraintType.Work, mode, covers, parcels, domain);
    }

    @Override
    public void post(CoverAllocationProblem cap) {
        EconomicCoverAllocationProblem ecap = (EconomicCoverAllocationProblem)cap;
        this.mp = ecap.getManagmentProfil();
        IntVar work = VF.bounded((String)"work", (int)0, (int)2000000000, (Solver)ecap.solver());
        ecap.solver().post(ICF.scalar((IntVar[])ecap.coverAreas(), (int[])this.mp.works(), (IntVar)work));
        switch (this.mode()) {
            case ONLY: {
                this.post(ecap, this.domain(), work);
                break;
            }
            case NEVER: {
                this.post(ecap, this.domain().inverse(), work);
                break;
            }
            default: {
                throw new IllegalArgumentException("mode " + (Object)((Object)this.mode()) + " is not supported for constraint type " + (Object)((Object)this.type()));
            }
        }
    }

    private void post(CoverAllocationProblem cap, Domain<Integer, Integer> domain, IntVar work) {
        cap.solver().post(domain.postIntVar(work));
    }

    @Override
    public boolean check(Instant start, Instant end, boolean verbose) {
        boolean ok = true;
        StringBuilder sb = new StringBuilder();
        int supermin = Integer.MAX_VALUE;
        int supermax = Integer.MIN_VALUE;
        YearDelay d = new YearDelay(1);
        Instant t = start;
        while (t.isBefore(end) || t.equals(end)) {
            int work = 0;
            for (Parcel p : this.location()) {
                CoverUnit c = (CoverUnit)p.getAttribute("cover").getValue(t);
                if (!this.covers().contains(c)) continue;
                work += this.mp.work(c, p.getArea());
            }
            supermin = Math.min(supermin, work);
            supermax = Math.max(supermax, work);
            switch (this.mode()) {
                case ONLY: {
                    if (this.domain().accept(work)) break;
                    ok = false;
                    if (verbose) {
                        sb.append("BAD : work  = " + work + " not in domain " + this.domain() + "\n");
                        break;
                    }
                    return ok;
                }
                case NEVER: {
                    if (!this.domain().accept(work)) break;
                    ok = false;
                    if (verbose) {
                        sb.append("BAD : profit = " + work + " not in domain " + this.domain() + "\n");
                        break;
                    }
                    return ok;
                }
                default: {
                    throw new IllegalArgumentException("mode " + (Object)((Object)this.mode()) + " is not supported for constraint type " + (Object)((Object)this.type()));
                }
            }
            t = ((Delay)d).next(t);
        }
        if (verbose) {
            if (ok) {
                if (supermin == supermax) {
                    sb.append("GOOD : cover " + this.covers().toString() + " has work = " + supermin);
                } else {
                    sb.append("GOOD : cover " + this.covers().toString() + " has work between min = " + supermin + " and max = " + supermax);
                }
            }
            System.out.println(sb.toString());
        }
        return ok;
    }
}

