/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.economic.constraint;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintMode;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintType;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.CoverAllocationConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.domain.Domain;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.EconomicProfil;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.csp.EconomicCoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.Set;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.VF;

public class ProfitVariabilityConstraint
extends CoverAllocationConstraint<Integer, Integer> {
    private static final long serialVersionUID = 1L;
    private EconomicProfil ep;
    private int paramDiv = 10000;

    public ProfitVariabilityConstraint(String code, boolean checkOnly, ConstraintMode mode, Set<Cover> covers, Set<Parcel> parcels, Domain<Integer, Integer> domain) {
        super(code, checkOnly, ConstraintType.ProfitVariability, mode, covers, parcels, domain);
    }

    @Override
    public void post(CoverAllocationProblem cap) {
        EconomicCoverAllocationProblem ecap = (EconomicCoverAllocationProblem)cap;
        this.ep = ecap.getEconomicProfil();
        IntVar profit = VF.bounded((String)"profit", (int)0, (int)100000000, (Solver)ecap.solver());
        ecap.solver().post(ICF.scalar((IntVar[])ecap.coverAreas(), (int[])this.ep.profits(), (IntVar)profit));
        int[][] historicalProfits = this.ep.getHistoricalProfits();
        int nbCombinations = historicalProfits[0].length;
        int nbCovers = ecap.coverAreas().length;
        IntVar[] profits = new IntVar[nbCombinations + 1];
        IntVar profitdiv10000 = VF.bounded((String)"profitdiv10000", (int)0, (int)10000, (Solver)ecap.solver());
        IntVar divisor = VF.bounded((String)"divisor", (int)this.paramDiv, (int)this.paramDiv, (Solver)ecap.solver());
        ecap.solver().post(ICF.eucl_div((IntVar)profit, (IntVar)divisor, (IntVar)profitdiv10000));
        profits[0] = profitdiv10000;
        IntVar[] profitcarres = new IntVar[nbCombinations + 1];
        IntVar profitcarre = VF.bounded((String)"profitcarre", (int)0, (int)10000000, (Solver)ecap.solver());
        ecap.solver().post(ICF.square((IntVar)profitcarre, (IntVar)profitdiv10000));
        profitcarres[0] = profitcarre;
        for (int h = 0; h < nbCombinations; ++h) {
            IntVar profith = VF.bounded((String)("profit" + h), (int)0, (int)100000000, (Solver)ecap.solver());
            int[] hp = new int[nbCovers];
            for (int s = 0; s < nbCovers; ++s) {
                hp[s] = historicalProfits[s][h];
            }
            ecap.solver().post(ICF.scalar((IntVar[])ecap.coverAreas(), (int[])hp, (IntVar)profith));
            IntVar profithdiv10000 = VF.bounded((String)("profit" + h + "div10000"), (int)0, (int)10000, (Solver)ecap.solver());
            ecap.solver().post(ICF.eucl_div((IntVar)profith, (IntVar)divisor, (IntVar)profithdiv10000));
            profits[h + 1] = profithdiv10000;
            IntVar profithcarre = VF.bounded((String)("profit" + h + "carre"), (int)0, (int)10000000, (Solver)ecap.solver());
            ecap.solver().post(ICF.square((IntVar)profithcarre, (IntVar)profithdiv10000));
            profitcarres[h + 1] = profithcarre;
        }
        IntVar sum = VF.bounded((String)"sum", (int)0, (int)100000, (Solver)ecap.solver());
        ecap.solver().post(ICF.sum((IntVar[])profits, (IntVar)sum));
        IntVar nbcombinationsplusone = VF.bounded((String)"nbcover", (int)(nbCombinations + 1), (int)(nbCombinations + 1), (Solver)ecap.solver());
        IntVar moyenne = VF.bounded((String)"moyenne", (int)0, (int)10000, (Solver)ecap.solver());
        ecap.solver().post(ICF.eucl_div((IntVar)sum, (IntVar)nbcombinationsplusone, (IntVar)moyenne));
        IntVar moyennecarre = VF.bounded((String)"moyennecarre", (int)0, (int)10000000, (Solver)ecap.solver());
        ecap.solver().post(ICF.square((IntVar)moyennecarre, (IntVar)moyenne));
        IntVar sumprofitcarres = VF.bounded((String)"sumprofitcarres", (int)0, (int)100000000, (Solver)ecap.solver());
        ecap.solver().post(ICF.sum((IntVar[])profitcarres, (IntVar)sumprofitcarres));
        IntVar sumprofitcarressurtaille = VF.bounded((String)"sumprofitcarressurtaille", (int)0, (int)10000000, (Solver)ecap.solver());
        ecap.solver().post(ICF.eucl_div((IntVar)sumprofitcarres, (IntVar)nbcombinationsplusone, (IntVar)sumprofitcarressurtaille));
        IntVar variance = VF.bounded((String)"variance", (int)0, (int)100000000, (Solver)ecap.solver());
        ecap.solver().post(ICF.distance((IntVar)sumprofitcarressurtaille, (IntVar)moyennecarre, (String)"=", (IntVar)variance));
        IntVar powecarttype = VF.bounded((String)"powecarttype", (int)0, (int)100000000, (Solver)ecap.solver());
        ecap.solver().post(ICF.distance((IntVar)powecarttype, (IntVar)variance, (String)"<", (int)1000));
        IntVar ecarttype = VF.bounded((String)"ecarttype", (int)0, (int)10000, (Solver)ecap.solver());
        ecap.solver().post(ICF.square((IntVar)powecarttype, (IntVar)ecarttype));
        IntVar ecarttype10000 = VF.bounded((String)"ecarttype10000", (int)0, (int)100000000, (Solver)ecap.solver());
        ecap.solver().post(ICF.times((IntVar)ecarttype, (int)10000, (IntVar)ecarttype10000));
        IntVar coeffvar = VF.bounded((String)"coeffvar", (int)0, (int)100000, (Solver)ecap.solver());
        ecap.solver().post(ICF.eucl_div((IntVar)ecarttype10000, (IntVar)moyenne, (IntVar)coeffvar));
    }

    private void post(CoverAllocationProblem cap, Domain<Integer, Integer> domain, IntVar coeffvar) {
        cap.solver().post(domain.postIntVar(coeffvar));
    }

    @Override
    public boolean check(Instant start, Instant end, boolean verbose) {
        boolean ok = true;
        return ok;
    }
}

