/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.domain;

import fr.inra.sad.bagap.apiland.capfarm.model.domain.Domain;
import fr.inra.sad.bagap.apiland.capfarm.model.domain.SimpleDomain;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.variables.IntVar;

public class NumberDomain<D extends Number, E extends Number>
extends SimpleDomain<D, E> {
    private String operator;

    public NumberDomain(String operator, D value) {
        super(value);
        this.operator = operator;
    }

    public NumberDomain(String operator, D value, Domain<D, E> inverse) {
        super(value, inverse);
        this.operator = operator;
    }

    public String toString() {
        return this.operator + " " + this.value();
    }

    @Override
    public boolean accept(Number v) {
        double vv = v.doubleValue();
        switch (this.operator) {
            case "=": {
                return vv == ((Number)this.value()).doubleValue();
            }
            case "!=": {
                return vv != ((Number)this.value()).doubleValue();
            }
            case "<": {
                return vv < ((Number)this.value()).doubleValue();
            }
            case ">": {
                return vv > ((Number)this.value()).doubleValue();
            }
            case "<=": {
                return vv <= ((Number)this.value()).doubleValue();
            }
            case ">=": {
                return vv >= ((Number)this.value()).doubleValue();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Domain<D, E> inverse() {
        if (this.inverse == null) {
            String op = "";
            switch (this.operator) {
                case "=": {
                    op = "!=";
                    break;
                }
                case "!=": {
                    op = "=";
                    break;
                }
                case "<": {
                    op = ">=";
                    break;
                }
                case ">": {
                    op = "<=";
                    break;
                }
                case "<=": {
                    op = ">";
                    break;
                }
                case ">=": {
                    op = "<";
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.inverse = new NumberDomain<Number, E>(op, (Number)this.value(), this);
        }
        return this.inverse;
    }

    public String operator() {
        return this.operator;
    }

    @Override
    public Constraint postIntVar(IntVar intVar) {
        return ICF.arithm((IntVar)intVar, (String)this.operator(), (int)((Number)this.value()).intValue());
    }

    @Override
    public Constraint postSpatialPattern(IntVar edgeLength) {
        return ICF.arithm((IntVar)edgeLength, (String)this.operator(), (int)((Number)this.value()).intValue());
    }
}

