/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.constraint;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintMode;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintType;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.CoverAllocationConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.Set;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.variables.IntVar;

public class OnLocationConstraint
extends CoverAllocationConstraint<Integer, Integer> {
    private static final long serialVersionUID = 1L;

    public OnLocationConstraint(String code, boolean checkOnly, ConstraintMode mode, Set<Cover> covers, Set<Parcel> parcels) {
        super(code, checkOnly, ConstraintType.OnLocation, mode, covers, parcels, null);
    }

    @Override
    public void post(CoverAllocationProblem cap) {
        switch (this.mode()) {
            case ONLY: {
                for (Parcel p : cap.allocator().parcels()) {
                    if (this.location().contains(p)) continue;
                    int ip = cap.parcels().get(p);
                    for (CoverUnit c : this.covers()) {
                        int ic = cap.covers().get(c);
                        cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ic, ip), (String)"=", (int)0));
                    }
                }
                break;
            }
            case NEVER: {
                for (Parcel p : this.location()) {
                    int ip = cap.parcels().get(p);
                    for (CoverUnit c : this.covers()) {
                        int ic = cap.covers().get(c);
                        cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ic, ip), (String)"=", (int)0));
                    }
                }
                break;
            }
            case ALWAYS: {
                for (Parcel p : this.location()) {
                    int ip = cap.parcels().get(p);
                    for (CoverUnit cu : cap.allocator().coverUnits()) {
                        if (this.covers().contains(cu)) continue;
                        int ic = cap.covers().get(cu);
                        cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ic, ip), (String)"=", (int)0));
                    }
                }
                break;
            }
            case AROUND: {
                for (Parcel p : cap.allocator().parcels()) {
                    if (this.location().contains(p)) continue;
                    int ip = cap.parcels().get(p);
                    for (CoverUnit cu : cap.allocator().coverUnits()) {
                        if (this.covers().contains(cu)) continue;
                        int ic = cap.covers().get(cu);
                        cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ic, ip), (String)"=", (int)0));
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("mode " + (Object)((Object)this.mode()) + " is not supported for constraint type " + (Object)((Object)this.type()));
            }
        }
    }

    @Override
    public boolean check(Instant start, Instant end, boolean verbose) {
        boolean ok = true;
        StringBuilder sb = new StringBuilder();
        sb.append("on location ");
        if (verbose) {
            if (ok) {
                sb.append("GOOD : cover " + this.covers().toString() + " is " + (Object)((Object)this.mode()) + " on " + this.domain());
            }
            System.out.println(sb.toString());
        }
        return ok;
    }
}

