/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.constraint;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintMode;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintType;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.CoverAllocationConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.Set;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.constraints.LCF;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;

public class LinkedFieldsConstraint
extends CoverAllocationConstraint<Integer, Integer> {
    private static final long serialVersionUID = 1L;

    public LinkedFieldsConstraint(String code, boolean checkOnly, ConstraintMode mode, Set<Cover> covers, Set<Parcel> parcels) {
        super(code, checkOnly, ConstraintType.LinkedFields, mode, covers, parcels, null);
    }

    @Override
    public void post(CoverAllocationProblem cap) {
        switch (this.mode()) {
            case NEVER: {
                for (Parcel p1 : this.location()) {
                    int ip1 = cap.parcels().get(p1);
                    for (Parcel p2 : this.location()) {
                        int ip2 = cap.parcels().get(p2);
                        if (p1 == p2) continue;
                        for (CoverUnit c : this.covers()) {
                            int ic = cap.covers().get(c);
                            LCF.ifThen((BoolVar)cap.coversAndParcels(ic, ip1), (Constraint)ICF.arithm((IntVar)cap.coversAndParcels(ic, ip2), (String)"=", (int)0));
                        }
                    }
                }
                break;
            }
            case ALWAYS: {
                for (Parcel p1 : this.location()) {
                    int ip1 = cap.parcels().get(p1);
                    for (Parcel p2 : this.location()) {
                        int ip2 = cap.parcels().get(p2);
                        if (p1 == p2) continue;
                        for (CoverUnit c : this.covers()) {
                            int ic = cap.covers().get(c);
                            LCF.ifThen((BoolVar)cap.coversAndParcels(ic, ip1), (Constraint)ICF.arithm((IntVar)cap.coversAndParcels(ic, ip2), (String)"=", (int)1));
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("mode " + (Object)((Object)this.mode()) + " is not supported for constraint type " + (Object)((Object)this.type()));
            }
        }
    }

    @Override
    public boolean check(Instant start, Instant end, boolean verbose) {
        boolean ok = true;
        StringBuilder sb = new StringBuilder();
        sb.append("linkedfields ");
        if (verbose) {
            if (ok) {
                // empty if block
            }
            System.out.println(sb.toString());
        }
        return ok;
    }
}

