/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.constraint;

import fr.inra.sad.bagap.apiland.capfarm.model.GenericFarmingSystem;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintMode;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintType;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.GenericCoverAllocationConstraint;

public class GenericConstraintBuilder {
    private GenericFarmingSystem system;
    private String code;
    private String[] covers;
    private ConstraintType type;
    private ConstraintMode mode;
    private String location;
    private String domain;
    private String[] params;

    public GenericConstraintBuilder(GenericFarmingSystem system) {
        this.system = system;
        this.reset();
    }

    private void reset() {
        this.code = null;
        this.covers = null;
        this.type = null;
        this.mode = null;
        this.location = null;
        this.domain = null;
        this.params = null;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setCover(String ... covers) {
        this.covers = covers;
    }

    public String getCover() {
        return this.covers[0];
    }

    public void setType(ConstraintType type) {
        this.type = type;
    }

    public void setType(String type) {
        this.type = ConstraintType.valueOf(type);
    }

    public void setMode(ConstraintMode mode) {
        this.mode = mode;
    }

    public void setMode(String mode) {
        this.mode = ConstraintMode.valueOf(mode);
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setParams(String ... params) {
        this.params = params;
    }

    private void initBuild() {
        if (this.location == null) {
            this.setLocation("");
        }
        if (this.covers == null) {
            this.setCover("ALL");
        }
        if (this.mode == null) {
            this.setMode(ConstraintMode.ONLY);
        }
    }

    public GenericCoverAllocationConstraint build() {
        this.initBuild();
        GenericCoverAllocationConstraint constraint = new GenericCoverAllocationConstraint(this.code, this.type, this.mode, this.covers, this.location, this.domain, this.params);
        this.system.addConstraint(constraint);
        this.reset();
        return constraint;
    }
}

