/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.vector.output;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.metric.AbstractMetricOutput;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.analysis.vector.process.VectorProcess;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.CoordinateManager;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixFactory;

public class MatrixOutputV
extends AbstractMetricOutput {
    private String metric;
    private Matrix matrix;

    public MatrixOutputV(String metric, double buffer, Matrix m) {
        this.metric = buffer + "_" + metric;
        this.matrix = MatrixFactory.get(m.getType()).create(m);
    }

    public String toString() {
        return this.metric;
    }

    @Override
    public void notify(Analysis ma, AnalysisState s) {
        switch (s) {
            case INIT: {
                this.matrix.init(0.0);
            }
        }
    }

    @Override
    public boolean acceptMetric(String metric) {
        return this.metric.equalsIgnoreCase(metric);
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    @Override
    public void notify(Metric m, String n, double v, Process p) {
        int y;
        int x;
        if (this.acceptMetric(n) && this.matrix.contains(x = CoordinateManager.getLocalX(this.matrix, ((VectorProcess)p).x()), y = CoordinateManager.getLocalY(this.matrix, ((VectorProcess)p).y()))) {
            this.matrix.put(x, y, this.formatDouble(v));
        }
    }
}

