/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.vector.output;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.metric.AbstractMetricOutput;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.analysis.vector.process.VectorProcess;
import fr.inra.sad.bagap.apiland.analysis.vector.window.SlidingWindowVectorAnalysis;
import fr.inra.sad.bagap.apiland.analysis.vector.window.WindowVectorAnalysis;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class AsciiGridOutputV
extends AbstractMetricOutput {
    private String ascii;
    private BufferedWriter out;
    private String metric;
    private double yGlobal;

    public AsciiGridOutputV(String metric, double buffer, String file) {
        this.metric = buffer + "_" + metric;
        this.ascii = file;
        this.yGlobal = -1.0;
    }

    public String toString() {
        return "ascii_" + this.metric;
    }

    @Override
    public void notify(Analysis ma, AnalysisState s) {
        switch (s) {
            case INIT: {
                this.notifyAnalysisInit((WindowVectorAnalysis)ma);
                break;
            }
            case FINISH: {
                this.notifyAnalysisFinish((WindowVectorAnalysis)ma);
            }
        }
    }

    private void notifyAnalysisInit(WindowVectorAnalysis wa) {
        try {
            this.out = new BufferedWriter(new FileWriter(this.ascii));
            int ncols = new Double(Math.floor((wa.layer().maxX() - wa.layer().minX()) / ((SlidingWindowVectorAnalysis)wa).displacement()) + 1.0).intValue();
            this.out.write("ncols " + ncols);
            this.out.newLine();
            int nrows = new Double(Math.floor((wa.layer().maxY() - wa.layer().minY()) / ((SlidingWindowVectorAnalysis)wa).displacement()) + 1.0).intValue();
            this.out.write("nrows " + nrows);
            this.out.newLine();
            this.out.write("xllcorner " + wa.layer().minX());
            this.out.newLine();
            this.out.write("yllcorner " + wa.layer().minY());
            this.out.newLine();
            this.out.write("cellsize " + ((SlidingWindowVectorAnalysis)wa).displacement());
            this.out.newLine();
            this.out.write("NODATA_value " + Raster.getNoDataValue());
            this.out.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void notifyAnalysisFinish(WindowVectorAnalysis wa) {
        try {
            this.out.newLine();
            this.out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean acceptMetric(String metric) {
        return this.metric.equalsIgnoreCase(metric);
    }

    @Override
    public void notify(Metric m, String n, double v, Process p) {
        if (this.acceptMetric(n)) {
            try {
                if (this.yGlobal == -1.0) {
                    this.out.write(this.format(v) + "");
                    this.yGlobal = ((VectorProcess)p).y();
                } else if (((VectorProcess)p).y() != this.yGlobal) {
                    this.out.newLine();
                    this.out.write(this.format(v));
                    this.yGlobal = ((VectorProcess)p).y();
                } else {
                    this.out.write(" " + this.format(v));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

