/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.window.shape;

import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.CircleWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.FunctionalWindowWithMap;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.FunctionalWindowWithMatrix;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.SquareWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.WindowShape;
import fr.inra.sad.bagap.apiland.analysis.process.ProcessType;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Friction;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;

public enum WindowShapeType {
    SQUARE,
    CIRCLE,
    FUNCTIONAL;


    public WindowShape create(int width) {
        switch (this) {
            case SQUARE: {
                return new SquareWindow(width);
            }
            case CIRCLE: {
                return new CircleWindow(width);
            }
        }
        throw new IllegalArgumentException("not implemented yet");
    }

    public WindowShape create(Matrix m, double d, Friction f, ProcessType<?> pt) {
        switch (this) {
            case FUNCTIONAL: {
                FunctionalWindowWithMap fw = new FunctionalWindowWithMap(m, d, f);
                pt.addObserver(fw);
                return fw;
            }
        }
        throw new IllegalArgumentException("not implemented yet");
    }

    public WindowShape create(Matrix m, double d, Matrix f, ProcessType<?> pt) {
        switch (this) {
            case FUNCTIONAL: {
                FunctionalWindowWithMatrix fwwm = new FunctionalWindowWithMatrix(m, d, f);
                pt.addObserver(fwwm);
                return fwwm;
            }
        }
        throw new IllegalArgumentException("not implemented yet");
    }

    public static WindowShapeType get(String type) {
        if (type.equalsIgnoreCase("square")) {
            return SQUARE;
        }
        if (type.equalsIgnoreCase("circle")) {
            return CIRCLE;
        }
        if (type.equalsIgnoreCase("functional")) {
            return FUNCTIONAL;
        }
        throw new IllegalArgumentException();
    }

    public static String getAbreviation(WindowShapeType type) {
        switch (type) {
            case SQUARE: {
                return "sq";
            }
            case CIRCLE: {
                return "cr";
            }
            case FUNCTIONAL: {
                return "fn";
            }
        }
        throw new IllegalArgumentException();
    }
}

