/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.window;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcessType;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.VolatileWindowAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.Window;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.ProcessState;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;

public class MapWindowMatrixAnalysis
extends WindowMatrixAnalysis
implements VolatileWindowAnalysis {
    private WindowMatrixProcess process;
    private Matrix matrixFilter;
    private Matrix matrixUnFilter;

    public MapWindowMatrixAnalysis(Matrix m, Window w, WindowMatrixProcessType pType, Matrix matrixFilter, Matrix matrixUnFilter) {
        super(m, w, pType);
        this.matrixFilter = matrixFilter;
        this.matrixUnFilter = matrixUnFilter;
    }

    @Override
    protected void doInit() {
    }

    @Override
    protected void doRun() {
        this.process = this.processType().create(this.window(), new Pixel(0, 0));
        for (int yt = 0; yt < this.matrix().numYTiles(); ++yt) {
            for (int xt = 0; xt < this.matrix().numXTiles(); ++xt) {
                this.distributeValues(xt, yt);
            }
        }
    }

    @Override
    protected void doClose() {
    }

    private void distributeValues(int xt, int yt) {
        int total = this.matrix().width() * this.matrix().height();
        for (int y = yt * this.matrix().tileHeight(); y < (yt + 1) * this.matrix().tileHeight() && y < this.matrix().height(); ++y) {
            for (int x = xt * this.matrix().tileWidth(); x < (xt + 1) * this.matrix().tileWidth() && x < this.matrix().width(); ++x) {
                double v = this.matrix().get(x, y);
                this.processType().setValue(x, y, v, null);
                if (this.matrixFilter != null && this.matrixFilter.get(x, y) == 0.0 || this.matrixUnFilter != null && this.matrixUnFilter.get(x, y) != 0.0) {
                    this.process.add(x, y, Raster.getNoDataValue());
                } else {
                    this.process.add(x, y, v);
                }
                this.updateProgression(total);
            }
        }
    }

    @Override
    public void notify(Process p, ProcessState s) {
        if (p instanceof WindowMatrixProcess && p.processType().equals(this.processType())) {
            switch (s) {
                case READY: {
                    this.notifyProcessReady((WindowMatrixProcess)p);
                    break;
                }
                case DONE: {
                    this.notifyProcessDone((WindowMatrixProcess)p);
                }
            }
        }
    }

    private void notifyProcessReady(WindowMatrixProcess p) {
        p.calculateMetrics();
    }

    private void notifyProcessDone(WindowMatrixProcess p) {
        p.delete();
    }

    @Override
    public Pixel next(Pixel pixel) {
        return pixel;
    }
}

