/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.output;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.metric.AbstractMetricOutput;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixFactory;

public class MatrixOutput
extends AbstractMetricOutput {
    private String metric;
    private Matrix matrix;
    private int delta;

    public MatrixOutput(String metric, Matrix m) {
        this.metric = metric;
        this.matrix = MatrixFactory.get(m.getType()).create(m);
    }

    public String toString() {
        return this.metric;
    }

    @Override
    public void notify(Analysis ma, AnalysisState s) {
        switch (s) {
            case INIT: {
                this.matrix.init(0.0);
                this.delta = ((WindowMatrixAnalysis)ma).delta();
            }
        }
    }

    @Override
    public boolean acceptMetric(String metric) {
        return this.metric.equalsIgnoreCase(metric);
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    @Override
    public void notify(Metric m, String n, double v, Process p) {
        if (this.acceptMetric(n)) {
            this.matrix.put(((WindowMatrixProcess)p).x() / this.delta, ((WindowMatrixProcess)p).y() / this.delta, this.formatDouble(v));
        }
    }
}

