/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis;

import fr.inra.sad.bagap.apiland.analysis.AnalysisObserver;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import java.util.HashSet;
import java.util.Set;

public abstract class Analysis {
    private Object result;
    private Set<AnalysisObserver> observers;
    private AnalysisState state = AnalysisState.IDLE;

    public Analysis() {
        this.observers = new HashSet<AnalysisObserver>();
    }

    protected void setResult(Object r) {
        this.result = r;
    }

    public Object getResult() {
        return this.result;
    }

    public Set<AnalysisObserver> observers() {
        return this.observers;
    }

    public void addObserver(AnalysisObserver o) {
        this.observers.add(o);
    }

    private void notifyObservers() {
        AnalysisState s = this.state;
        for (AnalysisObserver o : this.observers) {
            o.notify(this, s);
        }
    }

    public final void init() {
        this.state = AnalysisState.SETTING;
        this.notifyObservers();
        this.doInit();
        this.state = AnalysisState.INIT;
        this.notifyObservers();
    }

    protected abstract void doInit();

    public final void run() {
        this.state = AnalysisState.RUNNING;
        this.notifyObservers();
        this.doRun();
        this.state = AnalysisState.DONE;
        this.notifyObservers();
    }

    protected abstract void doRun();

    public final void close() {
        this.state = AnalysisState.CLOSING;
        this.notifyObservers();
        this.doClose();
        this.state = AnalysisState.FINISH;
        this.notifyObservers();
    }

    protected abstract void doClose();

    public final void abort() {
        this.state = AnalysisState.FAILED;
        this.notifyObservers();
        this.doAbort();
    }

    protected void doAbort() {
    }

    public Object allRun() {
        this.init();
        this.run();
        this.close();
        return this.result;
    }

    public void updateProgression(int total) {
        for (AnalysisObserver o : this.observers()) {
            o.updateProgression(this, total);
        }
    }
}

