/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.Iterator;
import org.geotools.data.DataSourceException;
import org.geotools.data.Diff;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.data.store.ContentState;
import org.geotools.data.store.DiffContentFeatureWriter;
import org.geotools.factory.Hints;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

public class DiffTransactionState
implements Transaction.State {
    protected Diff diff;
    protected Transaction transaction;
    protected ContentState state;

    public DiffTransactionState(ContentState state) {
        this.state = state;
        this.diff = new Diff();
    }

    protected DiffTransactionState(ContentState state, Diff diff) {
        this.state = state;
        this.diff = diff;
    }

    public Diff getDiff() {
        return this.diff;
    }

    @Override
    public synchronized void setTransaction(Transaction transaction) {
        if (this.transaction != null && transaction == null) {
            this.state.getEntry().clearTransaction(this.transaction);
        }
        this.transaction = transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void commit() throws IOException {
        if (this.diff.isEmpty()) {
            return;
        }
        ContentEntry entry = this.state.getEntry();
        Name name = entry.getName();
        ContentDataStore dataStore = entry.getDataStore();
        ContentFeatureSource source = (ContentFeatureSource)dataStore.getFeatureSource(name);
        if (!(source instanceof ContentFeatureStore)) throw new UnsupportedOperationException("not writable");
        ContentFeatureStore store = (ContentFeatureStore)dataStore.getFeatureSource(name, this.transaction);
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = store.getWriter((Filter)Filter.INCLUDE, 4);
        Exception cause = null;
        try {
            while (writer.hasNext()) {
                SimpleFeature feature = writer.next();
                String fid = feature.getID();
                if (!this.diff.getModified().containsKey(fid)) continue;
                SimpleFeature update = this.diff.getModified().get(fid);
                if (update == Diff.NULL) {
                    writer.remove();
                    continue;
                }
                try {
                    feature.setAttributes(update.getAttributes());
                    writer.write();
                }
                catch (IllegalAttributeException e) {
                    throw new DataSourceException("Could update " + fid, e);
                }
            }
            Diff diff = this.diff;
            synchronized (diff) {
                Iterator<String> i$ = this.diff.getAddedOrder().iterator();
                while (i$.hasNext()) {
                    String fid = i$.next();
                    SimpleFeature addedFeature = this.diff.getAdded().get(fid);
                    SimpleFeature nextFeature = writer.next();
                    if (nextFeature == null) {
                        throw new DataSourceException("Could not add " + fid);
                    }
                    try {
                        nextFeature.setAttributes(addedFeature.getAttributes());
                        nextFeature.getUserData().put(Hints.USE_PROVIDED_FID, true);
                        if (addedFeature.getUserData().containsKey(Hints.PROVIDED_FID)) {
                            String providedFid = (String)addedFeature.getUserData().get(Hints.PROVIDED_FID);
                            nextFeature.getUserData().put(Hints.PROVIDED_FID, providedFid);
                        } else {
                            nextFeature.getUserData().put(Hints.PROVIDED_FID, addedFeature.getID());
                        }
                        writer.write();
                    }
                    catch (IllegalAttributeException e) {
                        throw new DataSourceException("Could update " + fid, e);
                    }
                }
                return;
            }
        }
        catch (IOException e) {
            cause = e;
            throw e;
        }
        catch (RuntimeException e) {
            cause = e;
            throw e;
        }
        finally {
            try {
                writer.close();
                this.state.fireBatchFeatureEvent(true);
                this.diff.clear();
            }
            catch (IOException e) {
                if (cause == null) throw e;
                e.initCause(cause);
                throw e;
            }
            catch (RuntimeException e) {
                if (cause == null) throw e;
                e.initCause(cause);
                throw e;
            }
        }
    }

    @Override
    public synchronized void rollback() throws IOException {
        this.diff.clear();
        this.state.fireBatchFeatureEvent(false);
    }

    @Override
    public synchronized void addAuthorization(String AuthID) throws IOException {
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> diffWriter(ContentFeatureStore contentFeatureStore, FeatureReader<SimpleFeatureType, SimpleFeature> reader) {
        return new DiffContentFeatureWriter(contentFeatureStore, this.diff, reader);
    }
}

