/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.simul.operation;

import fr.inra.sad.bagap.apiland.simul.operation.Allocation;
import fr.inra.sad.bagap.apiland.simul.operation.OpAllocation;
import fr.inra.sad.bagap.apiland.simul.operation.OpTypeComposition;
import java.util.HashSet;
import java.util.Set;

public class OpTypeAllocation
extends OpTypeComposition {
    private static final long serialVersionUID = 1L;
    private Set<Allocation<?>> allocations = new HashSet();

    @Override
    public void reset() {
        super.reset();
        this.allocations = new HashSet();
    }

    private double addition() {
        double total = 0.0;
        for (Allocation<?> a : this.allocations) {
            total += a.getRate();
        }
        return total;
    }

    @Override
    public boolean isValid() {
        double total = this.addition();
        if (total <= 101.0 && total >= 99.0) {
            return super.isValid();
        }
        System.err.println("invalid allocation total --> " + total + ", must be (around) 100 %");
        return false;
    }

    private void setAllocation(Allocation<?> allocation) {
        this.allocations.add(allocation);
    }

    public Set<Allocation<?>> getAllocations() {
        return this.allocations;
    }

    @Override
    public boolean setParameter(String name, Object value) {
        if (name.equalsIgnoreCase("allocation")) {
            try {
                this.setAllocation((Allocation)value);
                return true;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return super.setParameter(name, value);
    }

    @Override
    public OpAllocation getOperation() {
        return new OpAllocation(this);
    }
}

