/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.simul.model;

import fr.inra.sad.bagap.apiland.core.element.DynamicElement;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.simul.Simulation;
import fr.inra.sad.bagap.apiland.simul.SimulationManager;
import fr.inra.sad.bagap.apiland.simul.Simulator;
import java.io.Serializable;

public abstract class Model
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Instant current;
    private DynamicElement element;
    private Model parent;

    public Model(String name, Simulator simulator) {
        this.name = name;
        this.setCurrent(simulator.manager().start());
    }

    public Model(String name, Instant start, Simulator simulator) {
        this.name = name;
        this.setCurrent(start);
    }

    public Model(String name, Simulator simulator, DynamicElement element) {
        this.name = name;
        this.setCurrent(simulator.manager().start());
        this.element = element;
    }

    public Model(String name, Instant start, Simulator simulator, DynamicElement element) {
        this.name = name;
        this.setCurrent(start);
        this.element = element;
    }

    public void setParent(Model parent) {
        this.parent = parent;
    }

    public Simulator simulator() {
        return this.simulation().simulator();
    }

    public Simulation simulation() {
        return this.parent.simulation();
    }

    public SimulationManager manager() {
        return this.simulator().manager();
    }

    protected Instant current() {
        return this.current;
    }

    public void setCurrent(Instant t) {
        this.current = t;
    }

    public void initCurrent(Instant t) {
        this.setCurrent(t);
    }

    public String getName() {
        return this.name;
    }

    public DynamicElement getElement() {
        return this.element;
    }

    public void setDynamicElement(DynamicElement element) {
        this.element = element;
    }

    public boolean deepContains(String name) {
        return this.name.equalsIgnoreCase(name);
    }

    public Model deepGet(String name) {
        if (this.deepContains(name)) {
            return this;
        }
        throw new IllegalArgumentException();
    }

    public abstract boolean run(Instant var1);

    public void delete() {
        this.name = null;
        this.current = null;
    }
}

