/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix;

import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixManager;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.grid.GridCoverage2D;

public class CoverageMatrix
implements Matrix {
    private static final long serialVersionUID = 1L;
    private GridCoverage2D grid;
    private double[] v = new double[1];
    private String file;
    private double cellsize;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private int noDataValue;
    private Set<Integer> values;

    public CoverageMatrix(GridCoverage2D grid, String file) {
        this.grid = grid;
        this.file = file;
    }

    @Override
    public MatrixType getType() {
        return MatrixType.ARRAY;
    }

    @Override
    public void visualize() {
        MatrixManager.visualize(this);
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public void display() {
        System.out.println(this);
        for (int i = 0; i < this.grid.getRenderedImage().getHeight(); ++i) {
            for (int j = 0; j < this.grid.getRenderedImage().getWidth(); ++j) {
                System.out.print(this.get(j, i) + " ");
            }
            System.out.println();
        }
    }

    @Override
    public double get(int x, int y) {
        if (x >= 0 && x < this.width() && y >= 0 && y < this.height()) {
            return ((PlanarImage)this.grid.getRenderedImage()).getData().getPixel(x, y, this.v)[0];
        }
        return -1.0;
    }

    @Override
    public double get(Pixel p) {
        return this.get(p.x(), p.y());
    }

    @Override
    public int height() {
        return ((PlanarImage)this.grid.getRenderedImage()).getHeight();
    }

    @Override
    public int width() {
        return ((PlanarImage)this.grid.getRenderedImage()).getWidth();
    }

    public GridCoverage2D getGrid() {
        return this.grid;
    }

    @Override
    public double cellsize() {
        return ((PlanarImage)this.grid.getRenderedImage()).getData().getTransferType();
    }

    @Override
    public double maxY() {
        return ((PlanarImage)this.grid.getRenderedImage()).getMaxY();
    }

    @Override
    public double minX() {
        return ((PlanarImage)this.grid.getRenderedImage()).getMinX();
    }

    @Override
    public double maxX() {
        return ((PlanarImage)this.grid.getRenderedImage()).getMaxX();
    }

    @Override
    public double minY() {
        return ((PlanarImage)this.grid.getRenderedImage()).getMinY();
    }

    @Override
    public int noDataValue() {
        return -1;
    }

    @Override
    public void setFile(String file) {
        this.file = file;
    }

    @Override
    public Set<Integer> values() {
        if (this.values == null) {
            this.values = new HashSet<Integer>();
            for (int j = 0; j < this.height(); ++j) {
                for (int i = 0; i < this.width(); ++i) {
                    this.values.add(new Double(((PlanarImage)this.grid.getRenderedImage()).getData().getPixel(i, j, this.v)[0]).intValue());
                }
            }
        }
        return this.values;
    }

    @Override
    public Iterator<Pixel> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void put(int x, int y, double value) {
    }

    @Override
    public void put(Pixel p, double value) {
    }

    @Override
    public void put(Raster r, double value) {
    }

    @Override
    public double getActiveArea() {
        return 0.0;
    }

    @Override
    public void init(double v) {
    }

    @Override
    public void getCouples(Matrix horizontals, Matrix verticals) {
    }

    @Override
    public int tileWidth() {
        return 0;
    }

    @Override
    public int tileHeight() {
        return 0;
    }

    @Override
    public int numXTiles() {
        return 0;
    }

    @Override
    public int numYTiles() {
        return 0;
    }

    @Override
    public boolean contains(Pixel p) {
        return false;
    }

    @Override
    public double minV() {
        return 0.0;
    }

    @Override
    public double maxV() {
        return 0.0;
    }

    @Override
    public boolean contains(int x, int y) {
        return false;
    }
}

