/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix;

import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.PixelManager;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class CoordinateManager {
    private static final int controlIndex = 500000;

    public static double getProjectedX(Matrix m, int x) {
        return (double)x * m.cellsize() + m.minX() + m.cellsize() / 2.0;
    }

    public static double getProjectedY(Matrix m, int y) {
        return m.cellsize() * (double)(m.height() - y) + m.minY() - m.cellsize() / 2.0;
    }

    public static int getLocalX(Matrix m, double x) {
        return new Double((x - m.minX()) / m.cellsize()).intValue();
    }

    public static int getLocalY(Matrix m, double y) {
        return m.height() - 1 - new Double((y - m.minY()) / m.cellsize()).intValue();
    }

    public static Set<Pixel> initWithPoints(Matrix m, String f) {
        TreeSet<Pixel> pixels = new TreeSet<Pixel>();
        try {
            CsvReader cr = new CsvReader(f);
            cr.setDelimiter(';');
            cr.readHeaders();
            while (cr.readRecord()) {
                double X = cr.get("X") != "" ? Double.parseDouble(cr.get("X")) : Double.parseDouble(cr.get("x"));
                double Y = cr.get("Y") != "" ? Double.parseDouble(cr.get("Y")) : Double.parseDouble(cr.get("y"));
                int x = CoordinateManager.getLocalX(m, X);
                int y = CoordinateManager.getLocalY(m, Y);
                String id = cr.get("id");
                if (!id.equals("")) {
                    pixels.add(PixelManager.get(x, y, id, X, Y));
                    continue;
                }
                id = cr.get("ID");
                if (!id.equals("")) {
                    pixels.add(PixelManager.get(x, y, id, X, Y));
                    continue;
                }
                id = cr.get("Id");
                if (!id.equals("")) {
                    pixels.add(PixelManager.get(x, y, id, X, Y));
                    continue;
                }
                id = cr.get("iD");
                if (!id.equals("")) {
                    pixels.add(PixelManager.get(x, y, id, X, Y));
                    continue;
                }
                pixels.add(PixelManager.get(x, y));
            }
            cr.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (CsvReader.FinalizedException ex) {
            ex.printStackTrace();
        }
        catch (CsvReader.CatastrophicException ex) {
            ex.printStackTrace();
        }
        return pixels;
    }

    public static Set<Pixel> initWithPixels(String f) {
        TreeSet<Pixel> pixels = new TreeSet<Pixel>();
        try {
            CsvReader cr = new CsvReader(f);
            cr.setDelimiter(';');
            cr.readHeaders();
            while (cr.readRecord()) {
                int x = new Integer(cr.get("X"));
                int y = new Integer(cr.get("Y"));
                pixels.add(PixelManager.get(x, y));
            }
            cr.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (CsvReader.FinalizedException ex) {
            ex.printStackTrace();
        }
        catch (CsvReader.CatastrophicException ex) {
            ex.printStackTrace();
        }
        return pixels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePoints(Set<Pixel> pixels, Matrix m, String file) {
        try (CsvWriter cw = new CsvWriter(file);){
            cw.setDelimiter(';');
            cw.write("X");
            cw.write("Y");
            cw.endRecord();
            for (Pixel p : pixels) {
                cw.write(CoordinateManager.getProjectedX(m, p.x()) + "");
                cw.write(CoordinateManager.getProjectedY(m, p.y()) + "");
                cw.endRecord();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePixels(Set<Pixel> pixels, Matrix m, String file) {
        try (CsvWriter cw = new CsvWriter(file);){
            cw.setDelimiter(';');
            cw.write("X");
            cw.write("Y");
            cw.endRecord();
            for (Pixel p : pixels) {
                cw.write(p.x() + "");
                cw.write(p.y() + "");
                cw.endRecord();
            }
        }
    }

    public static void dispatch(Set<Pixel> pixels, Matrix m, int n) {
        pixels.add(CoordinateManager.getRandomPixel(m));
        int index = 0;
        while (pixels.size() < n) {
            if (index++ > 500000) {
                throw new IllegalArgumentException("incompatible parameters for matrix " + m + " : number = " + n + ", maximum observed = " + pixels.size());
            }
            Pixel pixel = CoordinateManager.getRandomPixel(m);
            boolean ok = true;
            if (pixels.contains(pixel)) {
                ok = false;
            }
            if (!ok) continue;
            pixels.add(pixel);
        }
    }

    public static void dispatch(Set<Pixel> pixels, Matrix m, int n, int d, Set<Integer> with, Set<Integer> without) throws IllegalArgumentException {
        pixels.add(CoordinateManager.getRandomPixel(m));
        int index = 0;
        while (pixels.size() < n) {
            if (index++ > 500000) {
                throw new IllegalArgumentException("incompatible parameters for matrix " + m + " : distance = " + d + ",  number = " + n + ", maximum observed = " + pixels.size());
            }
            Pixel pixel = CoordinateManager.getRandomPixel(m);
            double v = m.get(pixel);
            boolean ok = true;
            if (with != null) {
                ok = false;
                for (Integer c : with) {
                    if ((double)c.intValue() != v) continue;
                    ok = true;
                    break;
                }
            }
            if (without != null) {
                for (Integer c : without) {
                    if ((double)c.intValue() != v) continue;
                    ok = false;
                    break;
                }
            }
            if (!ok) continue;
            if (d != -1 && d != 0 && d != 1) {
                for (Pixel p : pixels) {
                    if (!(Pixel.distance(p, pixel) < (double)d)) continue;
                    ok = false;
                    break;
                }
            }
            if (!ok) continue;
            pixels.add(pixel);
        }
    }

    public static void dispatch(Set<Pixel> pixels, Set<Matrix> matrix, int n, int d, Set<Integer> with, Set<Integer> without) throws IllegalArgumentException {
        Matrix m = matrix.iterator().next();
        pixels.add(CoordinateManager.getRandomPixel(m));
        int index = 0;
        HashSet<Integer> values = new HashSet<Integer>();
        while (pixels.size() < n) {
            int v;
            Iterator iterator;
            Iterator<Serializable> iterator2;
            if (index++ > 500000) {
                throw new IllegalArgumentException("incompatible parameters for matrix " + m + " : distance = " + d + ",  number = " + n + ", maximum observed = " + pixels.size());
            }
            Pixel pixel = CoordinateManager.getRandomPixel(m);
            values.clear();
            for (Matrix mat : matrix) {
                values.add(new Double(mat.get(pixel)).intValue());
            }
            boolean ok = true;
            if (with != null) {
                ok = false;
                iterator2 = with.iterator();
                while (iterator2.hasNext()) {
                    int c = (Integer)iterator2.next();
                    iterator = values.iterator();
                    while (iterator.hasNext()) {
                        v = (Integer)iterator.next();
                        if (c != v) continue;
                        ok = true;
                        break;
                    }
                    if (!ok) continue;
                    break;
                }
            }
            if (without != null) {
                iterator2 = without.iterator();
                while (iterator2.hasNext()) {
                    int c = (Integer)iterator2.next();
                    iterator = values.iterator();
                    while (iterator.hasNext()) {
                        v = (Integer)iterator.next();
                        if (c != v) continue;
                        ok = false;
                        break;
                    }
                    if (ok) continue;
                    break;
                }
            }
            if (!ok) continue;
            if (d != -1 && d != 0 && d != 1) {
                for (Pixel p : pixels) {
                    if (!(Pixel.distance(p, pixel) < (double)d)) continue;
                    ok = false;
                    break;
                }
            }
            if (!ok) continue;
            pixels.add(pixel);
        }
    }

    public static void dispatch(Set<Pixel> pixels, Matrix m, int n, int d) {
        pixels.add(CoordinateManager.getRandomPixel(m));
        int index = 0;
        while (pixels.size() < n) {
            if (index++ > 500000) {
                throw new IllegalArgumentException("incompatible parameters for matrix " + m + " : distance = " + d + ",  number = " + n + ", maximum observed = " + pixels.size());
            }
            Pixel pixel = CoordinateManager.getRandomPixel(m);
            boolean ok = true;
            for (Pixel p : pixels) {
                if (!(Pixel.distance(p, pixel) < (double)d)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            pixels.add(pixel);
        }
    }

    public static void dispatchWithFilter(Set<Pixel> pixels, Matrix m, int s, int n, int ... cat) {
        pixels.add(CoordinateManager.getRandomPixel(m));
        int index = 0;
        while (pixels.size() < n) {
            if (index++ > 500000) {
                throw new IllegalArgumentException("incompatible parameters for matrix " + m + " : size = " + s + ",  number = " + n + ", maximum observed = " + pixels.size());
            }
            Pixel pixel = CoordinateManager.getRandomPixel(m);
            double v = m.get(pixel);
            boolean ok = false;
            Object object = cat;
            int n2 = ((int[])object).length;
            for (int i = 0; i < n2; ++i) {
                Integer c = object[i];
                if ((double)c.intValue() != v) continue;
                ok = true;
                break;
            }
            if (!ok) continue;
            object = pixels.iterator();
            while (object.hasNext()) {
                Pixel p = (Pixel)object.next();
                if (!(Pixel.distance(p, pixel) < (double)s)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            pixels.add(pixel);
        }
    }

    public static void dispatchWithoutFilter(Set<Pixel> pixels, Matrix m, int s, int n, int ... cat) {
        pixels.add(CoordinateManager.getRandomPixel(m));
        int index = 0;
        while (pixels.size() < n) {
            if (index++ > 500000) {
                throw new IllegalArgumentException("incompatible parameters for matrix " + m + " : size = " + s + ",  number = " + n + ", maximum observed = " + pixels.size());
            }
            Pixel pixel = CoordinateManager.getRandomPixel(m);
            double v = m.get(pixel);
            boolean ok = true;
            Object object = cat;
            int n2 = ((int[])object).length;
            for (int i = 0; i < n2; ++i) {
                Integer c = object[i];
                if ((double)c.intValue() != v) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            object = pixels.iterator();
            while (object.hasNext()) {
                Pixel p = (Pixel)object.next();
                if (!(Pixel.distance(p, pixel) < (double)s)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            pixels.add(pixel);
        }
    }

    public static void dispatchWithoutNoData(Set<Pixel> pixels, Matrix m, int s, int n) {
        pixels.add(CoordinateManager.getRandomPixel(m));
        int index = 0;
        while (pixels.size() < n) {
            if (index++ > 500000) {
                throw new IllegalArgumentException("incompatible parameters for matrix " + m + " : size = " + s + ",  number = " + n + ", maximum observed = " + pixels.size());
            }
            Pixel pixel = CoordinateManager.getRandomPixel(m);
            if (m.get(pixel) == (double)Raster.getNoDataValue()) continue;
            boolean ok = true;
            for (Pixel p : pixels) {
                if (!(Pixel.distance(p, pixel) < (double)s)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            pixels.add(pixel);
        }
    }

    public static void dispatchWithFilterWithoutNoData(Set<Pixel> pixels, Matrix m, int s, int n, int ... cat) {
        pixels.add(CoordinateManager.getRandomPixel(m));
        int index = 0;
        while (pixels.size() < n) {
            if (index++ > 500000) {
                throw new IllegalArgumentException("incompatible parameters for matrix " + m + " : size = " + s + ",  number = " + n + ", maximum observed = " + pixels.size());
            }
            Pixel pixel = CoordinateManager.getRandomPixel(m);
            double v = m.get(pixel);
            if (v == (double)Raster.getNoDataValue()) continue;
            boolean ok = false;
            Object object = cat;
            int n2 = ((int[])object).length;
            for (int i = 0; i < n2; ++i) {
                Integer c = object[i];
                if ((double)c.intValue() != v) continue;
                ok = true;
                break;
            }
            if (!ok) continue;
            object = pixels.iterator();
            while (object.hasNext()) {
                Pixel p = (Pixel)object.next();
                if (!(Pixel.distance(p, pixel) < (double)s)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            pixels.add(pixel);
        }
    }

    public static void dispatchWithoutFilterWithoutNoData(Set<Pixel> pixels, Matrix m, int s, int n, int ... cat) {
        pixels.add(CoordinateManager.getRandomPixel(m));
        int index = 0;
        while (pixels.size() < n) {
            if (index++ > 500000) {
                throw new IllegalArgumentException("incompatible parameters for matrix " + m + " : size = " + s + ",  number = " + n + ", maximum observed = " + pixels.size());
            }
            Pixel pixel = CoordinateManager.getRandomPixel(m);
            double v = m.get(pixel);
            if (v == (double)Raster.getNoDataValue()) continue;
            boolean ok = true;
            Object object = cat;
            int n2 = ((int[])object).length;
            for (int i = 0; i < n2; ++i) {
                Integer c = object[i];
                if ((double)c.intValue() != v) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            object = pixels.iterator();
            while (object.hasNext()) {
                Pixel p = (Pixel)object.next();
                if (!(Pixel.distance(p, pixel) < (double)s)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            pixels.add(pixel);
        }
    }

    private static Pixel getRandomPixel(Matrix m) {
        return PixelManager.get(new Double(Math.random() * (double)m.width()).intValue(), new Double(Math.random() * (double)m.height()).intValue());
    }
}

