/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix;

import com.csvreader.CsvReader;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.ArrayMatrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixFactory;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.media.jai.PlanarImage;

public class ArrayMatrixFactory
extends MatrixFactory {
    private static double minx;
    private static double maxx;
    private static double miny;
    private static double maxy;
    private static double cellsize;
    private static int width;
    private static int height;
    private static int noDataValue;
    private static double[][] tab;
    private static Set<Integer> values;
    private static ArrayMatrixFactory factory;

    private ArrayMatrixFactory() {
    }

    public static ArrayMatrixFactory get() {
        return factory;
    }

    @Override
    public ArrayMatrix create(Matrix mRef) {
        return new ArrayMatrix(mRef);
    }

    @Override
    public ArrayMatrix create(int width, int height, double cellsize, double minX, double maxX, double minY, double maxY, int noData) {
        return new ArrayMatrix(width, height, cellsize, minX, maxX, minY, maxY, noData);
    }

    public Matrix createWithAsciiGrid(String ascii) {
        return this.createWithAsciiGrid(ascii, true);
    }

    public Matrix createWithAsciiGrid(String ascii, boolean read) {
        this.initWithAsciiGrid(ascii);
        if (read) {
            this.findValues(ascii);
        }
        return new ArrayMatrix(width, height, cellsize, minx, maxx, miny, maxy, noDataValue, tab, values, ascii);
    }

    private void initWithAsciiGrid(String ascii) throws NumberFormatException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(ascii));
            String line = br.readLine();
            String sep = String.valueOf(line.charAt(5));
            String[] s = line.split(sep);
            width = Integer.parseInt(s[s.length - 1]);
            s = br.readLine().split(sep);
            height = Integer.parseInt(s[s.length - 1]);
            s = br.readLine().split(sep);
            minx = Double.parseDouble(s[s.length - 1]);
            s = br.readLine().split(sep);
            miny = Double.parseDouble(s[s.length - 1]);
            s = br.readLine().split(sep);
            cellsize = Double.parseDouble(s[s.length - 1]);
            maxx = minx + (double)width * cellsize;
            maxy = miny + (double)height * cellsize;
            s = br.readLine().split(sep);
            if (!s[0].equalsIgnoreCase("NODATA_value")) {
                noDataValue = Raster.getNoDataValue();
                br.close();
                throw new NumberFormatException();
            }
            noDataValue = Integer.parseInt(s[s.length - 1]);
            Raster.setNoDataValue(noDataValue);
            br.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void findValues(String ascii) {
        tab = new double[height][width];
        values = new HashSet<Integer>();
        try {
            CsvReader cr = new CsvReader(ascii);
            cr.setDelimiter(' ');
            cr.readRecord();
            cr.readRecord();
            cr.readRecord();
            cr.readRecord();
            cr.readRecord();
            cr.readRecord();
            int y = 0;
            while (cr.readRecord()) {
                for (int x = 0; x < width; ++x) {
                    double v;
                    String s = cr.get(x);
                    if (s.equalsIgnoreCase("")) continue;
                    ArrayMatrixFactory.tab[y][x] = v = Double.parseDouble(s);
                    if (v == (double)noDataValue) continue;
                    values.add(new Double(s).intValue());
                }
                ++y;
            }
            cr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Matrix create(Matrix mRef, int divisor) {
        return null;
    }

    @Override
    public Matrix create(int width, int height, double cellsize, double minX, double maxX, double minY, double maxY, int noData, PlanarImage ref) {
        return null;
    }

    static {
        noDataValue = -1;
        factory = new ArrayMatrixFactory();
    }
}

