/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.space.impl.raster;

import com.vividsolutions.jts.geom.Coordinate;
import fr.inra.sad.bagap.apiland.core.space.impl.GeometryImpl;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.BoundaryIterator;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.CardinalMarginSinglePixelIterator;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.DiagonalMarginSinglePixelIterator;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.EuclidianDistanceSinglePixelIterator;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.FunctionalDistanceSinglePixelIterator;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.MarginSinglePixelIterator;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.PixelComposite;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.RasterComposite;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.SinglePixelIterator;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Friction;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.util.Iterator;

public class Pixel
extends Raster
implements Comparable<Pixel> {
    private static final long serialVersionUID = 1L;
    private int x;
    private int y;

    public Pixel(int x, int y) {
        this.x = x;
        this.y = y;
        this.smooth = true;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    @Override
    public Iterator<Pixel> iterator() {
        return new SinglePixelIterator(this);
    }

    public Coordinate getCentroid() {
        return new Coordinate((double)this.x * size + size / 2.0, (double)this.y * size + size / 2.0);
    }

    @Override
    public Iterator<Pixel> getBoundaries() {
        return new BoundaryIterator(this);
    }

    @Override
    public Iterator<Pixel> getMargins() {
        return new MarginSinglePixelIterator(this);
    }

    public Iterator<Pixel> getCardinalMargins() {
        return new CardinalMarginSinglePixelIterator(this);
    }

    public Iterator<Pixel> getDiagonalMargins() {
        return new DiagonalMarginSinglePixelIterator(this);
    }

    public Iterator<Pixel> getEuclidianDistanceMargins(double distance) {
        return new EuclidianDistanceSinglePixelIterator(this, distance);
    }

    public Iterator<Pixel> getFunctionalDistanceMargins(double distance, Matrix matrix, Matrix friction) {
        return new FunctionalDistanceSinglePixelIterator(this, distance, matrix, friction);
    }

    public Iterator<Pixel> getFunctionalDistanceMargins(double distance, Matrix matrix, Friction friction) {
        return new FunctionalDistanceSinglePixelIterator(this, distance, matrix, friction);
    }

    @Override
    public boolean equals(Object p) {
        if (p instanceof Pixel) {
            return this.x == ((Pixel)p).x && this.y == ((Pixel)p).y;
        }
        return false;
    }

    public int hashCode() {
        return this.x * 152 + this.y * 7 + 1;
    }

    public boolean equals(int x, int y) {
        return this.x == x && this.y == y;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int compareTo(Pixel p) {
        if (this.y < p.y) {
            return -1;
        }
        if (this.y > p.y) {
            return 1;
        }
        if (this.x < p.x) {
            return -1;
        }
        if (this.x > p.x) {
            return 1;
        }
        return 0;
    }

    @Override
    public Pixel clone() {
        return this;
    }

    @Override
    public int count() {
        return 1;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public double getArea() {
        return Math.pow(size, 2.0);
    }

    @Override
    public double getLength() {
        return 0.0;
    }

    @Override
    public boolean isSmooth() {
        return true;
    }

    @Override
    public Raster smooth() {
        return this;
    }

    @Override
    public boolean equals(GeometryImpl impl) {
        try {
            return ((Raster)impl).equalsPixel(this);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    protected boolean equalsPixel(Pixel impl) {
        return this.x == impl.x && this.y == impl.y;
    }

    @Override
    protected boolean equalsPixelComposite(PixelComposite impl) {
        return impl.equalsPixel(this);
    }

    @Override
    protected boolean equalsRasterComposite(RasterComposite impl) {
        return impl.equalsPixel(this);
    }

    @Override
    public boolean contains(GeometryImpl impl) {
        try {
            return ((Raster)impl).withinPixel(this);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    protected boolean containsPixel(Pixel impl) {
        return this.equalsPixel(impl);
    }

    @Override
    protected boolean containsPixelComposite(PixelComposite impl) {
        return impl.withinPixel(this);
    }

    @Override
    protected boolean containsRasterComposite(RasterComposite impl) {
        return impl.withinPixel(this);
    }

    @Override
    public boolean crosses(GeometryImpl impl) {
        try {
            return ((Raster)impl).crossesPixel(this);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    protected boolean crossesPixel(Pixel impl) {
        return false;
    }

    @Override
    protected boolean crossesPixelComposite(PixelComposite impl) {
        return impl.crossesPixel(this);
    }

    @Override
    protected boolean crossesRasterComposite(RasterComposite impl) {
        return impl.crossesPixel(this);
    }

    @Override
    public boolean touches(GeometryImpl impl) {
        try {
            return ((Raster)impl).touchesPixel(this);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    protected boolean touchesPixel(Pixel impl) {
        return this.x <= impl.x + 1 && this.x >= impl.x - 1 && this.y <= impl.y + 1 && this.y >= impl.y - 1 && !this.equalsPixel(impl);
    }

    public boolean rootTouches(Pixel impl) {
        return this.x == impl.x && this.y == impl.y - 1 || this.x == impl.x && this.y == impl.y + 1 || this.y == impl.y && this.x == impl.x - 1 || this.y == impl.y && this.x == impl.x + 1;
    }

    @Override
    protected boolean touchesPixelWithoutContainsTest(Pixel impl) {
        return this.x <= impl.x + 1 && this.x >= impl.x - 1 && this.y <= impl.y + 1 && this.y >= impl.y - 1;
    }

    @Override
    protected boolean touchesPixelComposite(PixelComposite impl) {
        return impl.touchesPixel(this);
    }

    @Override
    protected boolean touchesRasterComposite(RasterComposite impl) {
        return impl.touchesPixel(this);
    }

    @Override
    public boolean within(GeometryImpl impl) {
        try {
            return ((Raster)impl).containsPixel(this);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    protected boolean withinPixel(Pixel impl) {
        return this.equalsPixel(impl);
    }

    @Override
    protected boolean withinPixelComposite(PixelComposite impl) {
        return impl.containsPixel(this);
    }

    @Override
    protected boolean withinRasterComposite(RasterComposite impl) {
        return impl.containsPixel(this);
    }

    @Override
    public boolean intersects(GeometryImpl impl) {
        try {
            return ((Raster)impl).intersectsPixel(this);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    protected boolean intersectsPixel(Pixel impl) {
        return this.equalsPixel(impl);
    }

    @Override
    protected boolean intersectsPixelComposite(PixelComposite impl) {
        return impl.intersectsPixel(this);
    }

    @Override
    protected boolean intersectsRasterComposite(RasterComposite impl) {
        return impl.intersectsPixel(this);
    }

    @Override
    public boolean disjoint(GeometryImpl impl) {
        try {
            return ((Raster)impl).disjointPixel(this);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    protected boolean disjointPixel(Pixel impl) {
        return !this.equalsPixel(impl);
    }

    @Override
    protected boolean disjointPixelComposite(PixelComposite impl) {
        return impl.disjointPixel(this);
    }

    @Override
    protected boolean disjointRasterComposite(RasterComposite impl) {
        return impl.disjointPixel(this);
    }

    @Override
    public boolean overlaps(GeometryImpl impl) {
        try {
            return ((Raster)impl).overlapsPixel(this);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    protected boolean overlapsPixel(Pixel impl) {
        return this.equalsPixel(impl);
    }

    @Override
    protected boolean overlapsPixelComposite(PixelComposite impl) {
        return impl.overlapsPixel(this);
    }

    @Override
    protected boolean overlapsRasterComposite(RasterComposite impl) {
        return impl.overlapsPixel(this);
    }

    @Override
    public Raster addGeometryImpl(GeometryImpl impl) {
        try {
            return ((Raster)impl).addPixel(this);
        }
        catch (Exception ex) {
            return this;
        }
    }

    @Override
    protected Raster addPixel(Pixel impl) {
        if (this.equalsPixel(impl)) {
            return this;
        }
        if (this.touchesPixel(impl)) {
            PixelComposite pc = new PixelComposite();
            pc.add(this);
            pc.add(impl);
            pc.setSmooth(true);
            return pc;
        }
        RasterComposite rc = new RasterComposite();
        rc.add(this);
        rc.add(impl);
        rc.setSmooth(true);
        return rc;
    }

    @Override
    protected Raster addPixelComposite(PixelComposite impl) {
        return impl.addPixel(this);
    }

    @Override
    protected Raster addRasterComposite(RasterComposite impl) {
        return impl.addPixel(this);
    }

    @Override
    public double minX() {
        return this.x;
    }

    @Override
    public double maxX() {
        return this.x;
    }

    @Override
    public double minY() {
        return this.y;
    }

    @Override
    public double maxY() {
        return this.y;
    }

    @Override
    public Pixel getOne() {
        return this;
    }

    public static double distance(Pixel p1, Pixel p2) {
        return Math.sqrt(Math.pow(p1.x - p2.x, 2.0) + Math.pow(p1.y - p2.y, 2.0));
    }
}

