/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.space;

import fr.inra.sad.bagap.apiland.core.space.ComplexGeometry;
import fr.inra.sad.bagap.apiland.core.space.Curve;
import fr.inra.sad.bagap.apiland.core.space.Geometry;
import fr.inra.sad.bagap.apiland.core.space.GeometryManager;
import fr.inra.sad.bagap.apiland.core.space.MultiSurface;
import fr.inra.sad.bagap.apiland.core.space.Point;
import fr.inra.sad.bagap.apiland.core.space.Surfacic;
import fr.inra.sad.bagap.apiland.core.space.impl.GeometryImpl;

public class Surface
extends Geometry
implements Surfacic {
    private static final long serialVersionUID = 1L;

    public Surface(GeometryImpl impl) {
        super(impl);
    }

    public String toString() {
        return "surface  area = " + this.getArea();
    }

    @Override
    public Surface clone() {
        Surface clone = (Surface)super.clone();
        return clone;
    }

    @Override
    public Geometry smooth() {
        return this;
    }

    @Override
    public Geometry addGeometry(Geometry g) {
        return g.addSurface(this);
    }

    @Override
    public Geometry addPoint(Point g) {
        if (this.contains(g)) {
            return this.clone();
        }
        ComplexGeometry<Geometry> cg = new ComplexGeometry<Geometry>();
        cg.add(this);
        cg.add(g);
        return cg.smooth();
    }

    @Override
    public Geometry addCurve(Curve g) {
        if (this.intersects(g)) {
            if (this.contains(g)) {
                return this.clone();
            }
            return new Surface(GeometryManager.add(this.get(), g.get()));
        }
        if (this.touches(g)) {
            return new Surface(GeometryManager.add(this.get(), g.get()));
        }
        ComplexGeometry<Geometry> cg = new ComplexGeometry<Geometry>();
        cg.add(this);
        cg.add(g);
        return cg.smooth();
    }

    @Override
    public Geometry addSurface(Surface g) {
        if (this.intersects(g)) {
            if (this.contains(g)) {
                return this.clone();
            }
            if (this.within(g)) {
                return g.clone();
            }
            return new Surface(GeometryManager.add(this.get(), g.get()));
        }
        MultiSurface ms = new MultiSurface();
        ms.add(this);
        ms.add(g);
        return ms.smooth();
    }

    @Override
    public <G extends Geometry> Geometry addComplexGeometry(ComplexGeometry<G> g) {
        return g.addSurface(this);
    }
}

