/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.simul.farm;

import fr.inra.sad.bagap.apiland.capfarm.csp.FixedCoverAllocationProblemFactory;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.EconomicCoverAllocationProblemFactory;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.OptimizeEconomicCoverAllocationProblemFactory;
import fr.inra.sad.bagap.apiland.capfarm.simul.CSPCoverLocationModel;
import fr.inra.sad.bagap.apiland.capfarm.simul.CfmSimulator;
import fr.inra.sad.bagap.apiland.capfarm.simul.CoverAllocationProblemFactory;
import fr.inra.sad.bagap.apiland.capfarm.simul.GlobalCoverLocationModel;
import fr.inra.sad.bagap.apiland.capfarm.simul.MemoryCoverLocationModel;
import fr.inra.sad.bagap.apiland.capfarm.simul.farm.CfmFarmManager;

public class CfmFarmSimulator
extends CfmSimulator {
    private static final long serialVersionUID = 1L;

    public CfmFarmSimulator(CfmFarmManager manager) {
        super(manager);
    }

    @Override
    public CfmFarmManager manager() {
        return (CfmFarmManager)super.manager();
    }

    @Override
    protected void initFarms() {
        GlobalCoverLocationModel agriculture = new GlobalCoverLocationModel("agriculture", this);
        CoverAllocationProblemFactory factory = null;
        switch (this.manager().mode()) {
            case IDLE: {
                factory = new CoverAllocationProblemFactory();
                break;
            }
            case ECONOMIC: {
                factory = new EconomicCoverAllocationProblemFactory(this.manager().economicProfil(), this.manager().managmentProfil());
                break;
            }
            case OPTIMIZE: {
                factory = new OptimizeEconomicCoverAllocationProblemFactory(this.manager().economicProfil());
                break;
            }
            case SOLUTION: {
                factory = new FixedCoverAllocationProblemFactory();
            }
        }
        switch (this.manager().processMode()) {
            case ACTIVATE: {
                agriculture.add(new CSPCoverLocationModel(this, this.manager().farm(), factory));
                break;
            }
            case MEMORY: {
                agriculture.add(new MemoryCoverLocationModel((CfmSimulator)this, this.manager().farm()));
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)this.manager().processMode()) + " not implemented yet");
            }
        }
        this.model().add(agriculture);
    }
}

