/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.simul;

import com.csvreader.CsvReader;
import fr.inra.sad.bagap.apiland.capfarm.csp.ProbaTimeManager;
import fr.inra.sad.bagap.apiland.capfarm.simul.CfmFactory;
import fr.inra.sad.bagap.apiland.capfarm.simul.CfmManager;
import fr.inra.sad.bagap.apiland.simul.OutputAnalysis;
import fr.inra.sad.bagap.apiland.simul.Simulator;
import java.io.File;
import java.io.IOException;

public abstract class CfmSimulator
extends Simulator {
    private static final long serialVersionUID = 1L;

    public CfmSimulator(CfmManager manager) {
        super(manager, new CfmFactory());
    }

    @Override
    public CfmManager manager() {
        return (CfmManager)super.manager();
    }

    public void allRun() {
        this.init(1);
        this.run();
        this.close();
    }

    @Override
    protected void initModel() {
        this.initProbaTimes();
        this.initTerritory();
        this.initFarms();
        this.initOutput();
    }

    private void initProbaTimes() {
        try {
            File folder = new File(this.manager().probaTimeFolder().replace("file:/", ""));
            ProbaTimeManager.initProbaTimes();
            for (File duration : folder.listFiles()) {
                String name = duration.getName().replace(".txt", "");
                ProbaTimeManager.addProbaType(name);
                CsvReader cr = new CsvReader(duration.toString());
                cr.setDelimiter(';');
                cr.readHeaders();
                while (cr.readRecord()) {
                    int time = Integer.parseInt(cr.get("time"));
                    ProbaTimeManager.addProbaTime(name, time);
                    String[] probas = cr.get("probas").split("\\|");
                    ProbaTimeManager.addProbaTimes(name, time, probas);
                }
                cr.close();
            }
        }
        catch (CsvReader.CatastrophicException | CsvReader.FinalizedException | IOException e) {
            e.printStackTrace();
        }
    }

    protected abstract void initFarms();

    private void initTerritory() {
        this.map().put("territory", this.manager().territory());
    }

    private void initOutput() {
        for (OutputAnalysis oa : this.manager().outputs()) {
            this.addOutput(oa);
        }
    }
}

