/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.economic;

import com.csvreader.CsvReader;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.MaeliaManagmentProfil;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.ManagmentProfil;
import java.io.IOException;
import java.util.HashMap;

public class ManagmentProfilFactory {
    public static ManagmentProfil create(CoverUnit[] covers) {
        int[] works = new int[]{10, 5, 5, 20, 5, 15, 7, 5, 15, 7};
        return new MaeliaManagmentProfil(covers, works);
    }

    public static ManagmentProfil create(CoverUnit[] covers, String file) {
        try {
            CsvReader cr = new CsvReader(file);
            cr.setDelimiter(';');
            cr.readHeaders();
            HashMap<String, Integer> mworks = new HashMap<String, Integer>();
            while (cr.readRecord()) {
                String c = cr.get("cover");
                mworks.put(c, Integer.parseInt(cr.get("work")));
            }
            int[] works = new int[covers.length];
            for (int i = 0; i < covers.length; ++i) {
                works[i] = (Integer)mworks.get(covers[i].getCode());
            }
            MaeliaManagmentProfil mp = new MaeliaManagmentProfil(covers, works);
            cr.close();
            return mp;
        }
        catch (CsvReader.CatastrophicException | CsvReader.FinalizedException | IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException();
        }
    }
}

