/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.domain;

import fr.inra.sad.bagap.apiland.capfarm.model.domain.Domain;
import fr.inra.sad.bagap.apiland.capfarm.model.domain.SimpleDomain;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;

public class VariableValueDomain<D extends Number>
extends SimpleDomain<D, Parcel> {
    private String variable;
    private String operator;

    public VariableValueDomain(String variable, String operator, D value) {
        super(value);
        this.variable = variable;
        this.operator = operator;
    }

    public VariableValueDomain(String variable, String operator, D value, Domain<D, Parcel> inverse) {
        super(value, inverse);
        this.variable = variable;
        this.operator = operator;
    }

    public String toString() {
        return this.variable + " " + this.operator + " " + this.value();
    }

    @Override
    public boolean accept(Parcel p) {
        if (p.hasAttribute(this.variable)) {
            double v = ((Number)p.getAttribute(this.variable).getValue(null)).doubleValue();
            switch (this.operator) {
                case "=": {
                    return v == ((Number)this.value()).doubleValue();
                }
                case "!=": {
                    return v != ((Number)this.value()).doubleValue();
                }
                case "<": {
                    return v < ((Number)this.value()).doubleValue();
                }
                case ">": {
                    return v > ((Number)this.value()).doubleValue();
                }
                case "<=": {
                    return v <= ((Number)this.value()).doubleValue();
                }
                case ">=": {
                    return v >= ((Number)this.value()).doubleValue();
                }
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException(this.variable + " do not exists for parcel " + p);
    }

    @Override
    public Domain<D, Parcel> inverse() {
        if (this.inverse == null) {
            String op = "";
            switch (this.operator) {
                case "=": {
                    op = "!=";
                    break;
                }
                case "!=": {
                    op = "=";
                    break;
                }
                case "<": {
                    op = ">=";
                    break;
                }
                case ">": {
                    op = "<=";
                    break;
                }
                case "<=": {
                    op = ">";
                    break;
                }
                case ">=": {
                    op = "<";
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.inverse = new VariableValueDomain<Number>(this.variable, op, (Number)this.value(), this);
        }
        return this.inverse;
    }
}

