/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.constraint;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintMode;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintType;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.CoverAllocationConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.core.composition.DynamicAttribute;
import fr.inra.sad.bagap.apiland.core.composition.TemporalValue;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.constraints.LCF;
import org.chocosolver.solver.variables.IntVar;

public class TemporalPatternConstraint
extends CoverAllocationConstraint<Cover, Cover> {
    private static final long serialVersionUID = 1L;
    private Map<Integer, Cover> pattern;

    public TemporalPatternConstraint(String code, boolean checkOnly, ConstraintMode mode, Set<Cover> covers, Set<Parcel> parcels, Map<Integer, Cover> pattern) {
        super(code, checkOnly, ConstraintType.TemporalPattern, mode, covers, parcels, null);
        this.pattern = pattern;
    }

    @Override
    public void post(CoverAllocationProblem cap) {
        block4: for (Parcel p : this.location()) {
            int ip = cap.parcels().get(p);
            boolean hasPattern = true;
            if (((DynamicAttribute)p.getAttribute("cover")).getDynamics().size() >= this.pattern.size()) {
                Iterator<Serializable> ite = ((DynamicAttribute)p.getAttribute("cover")).getDynamics().iteratorInverse();
                int ind = 0;
                while (ite.hasNext() && ind < this.pattern.size()) {
                    CoverUnit cu = (CoverUnit)((TemporalValue)ite.next()).getValue();
                    if (cu.equals(this.pattern.get(ind++))) continue;
                    hasPattern = false;
                    break;
                }
            } else {
                hasPattern = false;
            }
            if (!hasPattern) continue;
            switch (this.mode()) {
                case NEVER: {
                    for (CoverUnit c : this.covers()) {
                        int ic = cap.covers().get(c);
                        cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ic, ip), (String)"=", (int)0));
                    }
                    continue block4;
                }
                case ONLY: {
                    if (this.hasSingleCover()) {
                        int ic = cap.covers().get(this.getSingleCover());
                        cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ic, ip), (String)"=", (int)1));
                        break;
                    }
                    Constraint[] cons = new Constraint[this.covers().size()];
                    int i = 0;
                    for (CoverUnit c : this.covers()) {
                        int ic = cap.covers().get(c);
                        cons[i++] = ICF.arithm((IntVar)cap.coversAndParcels(ic, ip), (String)"=", (int)1);
                    }
                    cap.solver().post(LCF.or((Constraint[])cons));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("mode " + (Object)((Object)this.mode()) + " is not supported for constraint type " + (Object)((Object)this.type()));
                }
            }
        }
    }

    @Override
    public boolean check(Instant start, Instant end, boolean verbose) {
        boolean ok = true;
        StringBuilder sb = new StringBuilder();
        ArrayList sequences = new ArrayList();
        for (Parcel p : this.location()) {
            sequences.clear();
            for (TemporalValue tv : (DynamicAttribute)p.getAttribute("cover")) {
                CoverUnit cu = (CoverUnit)tv.getValue();
                block6: for (int i = 0; i < sequences.size(); ++i) {
                    List seq = (List)sequences.get(i);
                    int size = seq.size();
                    if (size == this.pattern.size()) {
                        sequences.remove(i);
                        --i;
                        switch (this.mode()) {
                            case ONLY: {
                                if (this.covers().contains(cu)) continue block6;
                                ok = false;
                                if (verbose) {
                                    sb.append("BAD : TemporalPattern \n");
                                    continue block6;
                                }
                                return ok;
                            }
                            case NEVER: {
                                if (!this.covers().contains(cu)) continue block6;
                                ok = false;
                                if (verbose) {
                                    sb.append("BAD : TemporalPattern \n");
                                    continue block6;
                                }
                                return ok;
                            }
                            default: {
                                throw new IllegalArgumentException("mode " + (Object)((Object)this.mode()) + " is not supported for constraint type " + (Object)((Object)this.type()));
                            }
                        }
                    }
                    if (this.pattern.get(this.pattern.size() - size - 1).equals(cu)) {
                        ArrayList<CoverUnit> seq2 = new ArrayList<CoverUnit>();
                        seq2.addAll(seq);
                        seq2.add(cu);
                        sequences.set(i, seq2);
                        continue;
                    }
                    sequences.remove(i);
                    --i;
                }
                if (!this.pattern.get(1).equals(cu)) continue;
                ArrayList<CoverUnit> seq = new ArrayList<CoverUnit>();
                seq.add(cu);
                sequences.add(seq);
            }
        }
        if (verbose) {
            System.err.println(sb.toString());
        }
        return ok;
    }
}

