/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.constraint;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocator;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.LocationBaseListener;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.LocationParser;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.ErrorNode;

public class ConstraintLocationListener
extends LocationBaseListener {
    private CoverAllocator allocator;
    private Deque<List<Set<Parcel>>> stack;
    private List<Set<Parcel>> level;
    private Set<Parcel> local;
    private Deque<Boolean> signs;
    private boolean add;
    private boolean first;
    private int nbErrors;
    private StringBuffer error;

    public ConstraintLocationListener(CoverAllocator allocator) {
        this.allocator = allocator;
        this.stack = new ArrayDeque<List<Set<Parcel>>>();
        this.level = new ArrayList<Set<Parcel>>();
        this.signs = new ArrayDeque<Boolean>();
        this.error = new StringBuffer();
    }

    @Override
    public void enterLocalisation(@NotNull LocationParser.LocalisationContext ctx) {
        this.local = new TreeSet<Parcel>();
        this.add = true;
        this.first = true;
    }

    @Override
    public void exitLocalisation(@NotNull LocationParser.LocalisationContext ctx) {
        this.level.add(this.local);
    }

    @Override
    public void enterAndterme(@NotNull LocationParser.AndtermeContext ctx) {
        this.level.add(this.local);
        this.stack.push(this.level);
        this.level = new ArrayList<Set<Parcel>>();
        this.signs.push(this.add);
    }

    private Set<Parcel> and(Set<Parcel> s1, Set<Parcel> s2) {
        TreeSet<Parcel> l = new TreeSet<Parcel>();
        for (Parcel p1 : s1) {
            if (!s2.contains(p1)) continue;
            l.add(p1);
        }
        return l;
    }

    @Override
    public void exitAndterme(@NotNull LocationParser.AndtermeContext ctx) {
        Set<Parcel> land = this.level.get(0);
        for (int i = 1; i < this.level.size(); ++i) {
            land = this.and(land, this.level.get(i));
        }
        this.level = this.stack.pop();
        this.local = this.level.get(this.level.size() - 1);
        this.add = this.signs.pop();
        if (this.add) {
            for (Parcel p : land) {
                this.local.add(p);
            }
        } else {
            for (Parcel p : land) {
                this.local.remove(p);
            }
        }
    }

    @Override
    public void enterXorterme(@NotNull LocationParser.XortermeContext ctx) {
        this.level.add(this.local);
        this.stack.push(this.level);
        this.level = new ArrayList<Set<Parcel>>();
        this.signs.push(this.add);
    }

    @Override
    public void exitXorterme(@NotNull LocationParser.XortermeContext ctx) {
        TreeSet lxor = new TreeSet();
        Set<Parcel> land = this.level.get(0);
        lxor.addAll(this.level.get(0));
        for (int i = 1; i < this.level.size(); ++i) {
            land = this.and(land, this.level.get(i));
            lxor.addAll(this.level.get(i));
        }
        lxor.removeAll(land);
        this.level = this.stack.pop();
        this.local = this.level.get(this.level.size() - 1);
        this.add = this.signs.pop();
        if (this.add) {
            for (Parcel p : lxor) {
                this.local.add(p);
            }
        } else {
            for (Parcel p : lxor) {
                this.local.remove(p);
            }
        }
    }

    @Override
    public void enterPartout(@NotNull LocationParser.PartoutContext ctx) {
        this.local = this.allocator.parcels();
        this.first = false;
    }

    @Override
    public void enterPlusminus(@NotNull LocationParser.PlusminusContext ctx) {
        switch (ctx.getText()) {
            case "+": {
                this.add = true;
                break;
            }
            case "-": {
                this.add = false;
                if (!this.first) break;
                this.local = this.allocator.parcels();
                this.first = false;
            }
        }
    }

    @Override
    public void enterParcelles(@NotNull LocationParser.ParcellesContext ctx) {
        String[] pp = ctx.getText().replace("[", "").replace("]", "").split(",");
        if (this.add) {
            for (String p : pp) {
                this.local.add(this.allocator.parcel(p));
            }
        } else {
            for (String p : pp) {
                Parcel parcel = this.allocator.parcel(p);
                if (!this.local.contains(parcel)) continue;
                this.local.remove(parcel);
            }
        }
        this.first = false;
    }

    @Override
    public void enterBoolatt(@NotNull LocationParser.BoolattContext ctx) {
        String condition = ctx.getText().replace("[", "").replace("]", "");
        boolean trueValue = true;
        if (condition.contains("='F'") || condition.contains("=F")) {
            trueValue = false;
        }
        condition = condition.replace("='F'", "").replace("=F", "").replace("='T'", "").replace("=T", "");
        if (this.add) {
            if (trueValue) {
                for (Parcel p : this.allocator.parcels()) {
                    if (!((String)p.getAttribute(condition).getValue(null)).equals("T")) continue;
                    this.local.add(p);
                }
            } else {
                for (Parcel p : this.allocator.parcels()) {
                    if (!((String)p.getAttribute(condition).getValue(null)).equals("F")) continue;
                    this.local.add(p);
                }
            }
        } else if (trueValue) {
            for (Parcel p : this.allocator.parcels()) {
                if (!((String)p.getAttribute(condition).getValue(null)).equals("T")) continue;
                this.local.remove(p);
            }
        } else {
            for (Parcel p : this.allocator.parcels()) {
                if (!((String)p.getAttribute(condition).getValue(null)).equals("F")) continue;
                this.local.remove(p);
            }
        }
        this.first = false;
    }

    @Override
    public void enterNumatt(@NotNull LocationParser.NumattContext ctx) {
        block34: {
            String[] pp;
            int code;
            block33: {
                String condition = ctx.getText().replace("[", "").replace("]", "");
                code = -1;
                pp = null;
                if (condition.contains("<=")) {
                    pp = condition.split("<=");
                    code = 1;
                } else if (condition.contains(">=")) {
                    pp = condition.split(">=");
                    code = 2;
                } else if (condition.contains("=")) {
                    pp = condition.split("=");
                    code = 3;
                } else if (condition.contains("<")) {
                    pp = condition.split("<");
                    code = 4;
                } else if (condition.contains(">")) {
                    pp = condition.split(">");
                    code = 5;
                }
                if (!this.add) break block33;
                switch (code) {
                    case 1: {
                        for (Parcel p : this.allocator.parcels()) {
                            if (!(((Number)p.getAttribute(pp[0]).getValue(null)).doubleValue() <= Double.parseDouble(pp[1]))) continue;
                            this.local.add(p);
                        }
                        break block34;
                    }
                    case 2: {
                        for (Parcel p : this.allocator.parcels()) {
                            if (!(((Number)p.getAttribute(pp[0]).getValue(null)).doubleValue() >= Double.parseDouble(pp[1]))) continue;
                            this.local.add(p);
                        }
                        break block34;
                    }
                    case 3: {
                        for (Parcel p : this.allocator.parcels()) {
                            if (((Number)p.getAttribute(pp[0]).getValue(null)).doubleValue() != Double.parseDouble(pp[1])) continue;
                            this.local.add(p);
                        }
                        break block34;
                    }
                    case 4: {
                        for (Parcel p : this.allocator.parcels()) {
                            if (!(((Number)p.getAttribute(pp[0]).getValue(null)).doubleValue() < Double.parseDouble(pp[1]))) continue;
                            this.local.add(p);
                        }
                        break block34;
                    }
                    case 5: {
                        for (Parcel p : this.allocator.parcels()) {
                            if (!(((Number)p.getAttribute(pp[0]).getValue(null)).doubleValue() > Double.parseDouble(pp[1]))) continue;
                            this.local.add(p);
                        }
                        break;
                    }
                }
                break block34;
            }
            switch (code) {
                case 1: {
                    for (Parcel p : this.allocator.parcels()) {
                        if (!(((Number)p.getAttribute(pp[0]).getValue(null)).doubleValue() <= Double.parseDouble(pp[1]))) continue;
                        this.local.remove(p);
                    }
                    break;
                }
                case 2: {
                    for (Parcel p : this.allocator.parcels()) {
                        if (!(((Number)p.getAttribute(pp[0]).getValue(null)).doubleValue() >= Double.parseDouble(pp[1]))) continue;
                        this.local.remove(p);
                    }
                    break;
                }
                case 3: {
                    for (Parcel p : this.allocator.parcels()) {
                        if (((Number)p.getAttribute(pp[0]).getValue(null)).doubleValue() != Double.parseDouble(pp[1])) continue;
                        this.local.remove(p);
                    }
                    break;
                }
                case 4: {
                    for (Parcel p : this.allocator.parcels()) {
                        if (!(((Number)p.getAttribute(pp[0]).getValue(null)).doubleValue() < Double.parseDouble(pp[1]))) continue;
                        this.local.remove(p);
                    }
                    break;
                }
                case 5: {
                    for (Parcel p : this.allocator.parcels()) {
                        if (!(((Number)p.getAttribute(pp[0]).getValue(null)).doubleValue() > Double.parseDouble(pp[1]))) continue;
                        this.local.remove(p);
                    }
                    break;
                }
            }
        }
        this.first = false;
    }

    @Override
    public void enterArea(@NotNull LocationParser.AreaContext ctx) {
        String condition = ctx.getText().replace("AREA", "");
        int code = -1;
        String[] pp = null;
        if (condition.contains("<=")) {
            pp = condition.split("<=");
            code = 1;
        } else if (condition.contains(">=")) {
            pp = condition.split(">=");
            code = 2;
        } else if (condition.contains("=")) {
            pp = condition.split("=");
            code = 3;
        } else if (condition.contains("<")) {
            pp = condition.split("<");
            code = 4;
        } else if (condition.contains(">")) {
            pp = condition.split(">");
            code = 5;
        }
        if (this.add) {
            for (Parcel p : this.allocator.parcels()) {
                int area = p.getArea();
                switch (code) {
                    case 1: {
                        if (!((double)area <= Double.parseDouble(pp[1]) * 10000.0)) break;
                        this.local.add(p);
                        break;
                    }
                    case 2: {
                        if (!((double)area >= Double.parseDouble(pp[1]) * 10000.0)) break;
                        this.local.add(p);
                        break;
                    }
                    case 3: {
                        if ((double)area != Double.parseDouble(pp[1]) * 10000.0) break;
                        this.local.add(p);
                        break;
                    }
                    case 4: {
                        if (!((double)area < Double.parseDouble(pp[1]) * 10000.0)) break;
                        this.local.add(p);
                        break;
                    }
                    case 5: {
                        if (!((double)area > Double.parseDouble(pp[1]) * 10000.0)) break;
                        this.local.add(p);
                    }
                }
            }
        } else {
            for (Parcel p : this.allocator.parcels()) {
                int area = p.getArea();
                switch (code) {
                    case 1: {
                        if (!((double)area <= Double.parseDouble(pp[1]) * 10000.0)) break;
                        this.local.remove(p);
                        break;
                    }
                    case 2: {
                        if (!((double)area >= Double.parseDouble(pp[1]) * 10000.0)) break;
                        this.local.remove(p);
                        break;
                    }
                    case 3: {
                        if ((double)area != Double.parseDouble(pp[1]) * 10000.0) break;
                        this.local.remove(p);
                        break;
                    }
                    case 4: {
                        if (!((double)area < Double.parseDouble(pp[1]) * 10000.0)) break;
                        this.local.remove(p);
                        break;
                    }
                    case 5: {
                        if (!((double)area > Double.parseDouble(pp[1]) * 10000.0)) break;
                        this.local.remove(p);
                    }
                }
            }
        }
        this.first = false;
    }

    @Override
    public void enterDistance(@NotNull LocationParser.DistanceContext ctx) {
        String condition = ctx.getText().replace("DISTANCE(", "").replace(")", "");
        int code = -1;
        String[] pp = null;
        if (condition.contains("<=")) {
            pp = condition.split("<=");
            code = 1;
        } else if (condition.contains(">=")) {
            pp = condition.split(">=");
            code = 2;
        } else if (condition.contains("=")) {
            pp = condition.split("=");
            code = 3;
        } else if (condition.contains("<")) {
            pp = condition.split("<");
            code = 4;
        } else if (condition.contains(">")) {
            pp = condition.split(">");
            code = 5;
        }
        if (this.add) {
            for (Parcel p : this.allocator.parcels()) {
                int distance = this.allocator.getDistanceFromFacilitiesToParcel(pp[0], p);
                switch (code) {
                    case 1: {
                        if (!((double)distance <= Double.parseDouble(pp[1]) * 1000.0)) break;
                        this.local.add(p);
                        break;
                    }
                    case 2: {
                        if (!((double)distance >= Double.parseDouble(pp[1]) * 1000.0)) break;
                        this.local.add(p);
                        break;
                    }
                    case 3: {
                        if ((double)distance != Double.parseDouble(pp[1]) * 1000.0) break;
                        this.local.add(p);
                        break;
                    }
                    case 4: {
                        if (!((double)distance < Double.parseDouble(pp[1]) * 1000.0)) break;
                        this.local.add(p);
                        break;
                    }
                    case 5: {
                        if (!((double)distance > Double.parseDouble(pp[1]) * 1000.0)) break;
                        this.local.add(p);
                    }
                }
            }
        } else {
            for (Parcel p : this.allocator.parcels()) {
                int distance = this.allocator.getDistanceFromFacilitiesToParcel(pp[0], p);
                switch (code) {
                    case 1: {
                        if (!((double)distance <= Double.parseDouble(pp[1]) * 1000.0)) break;
                        this.local.remove(p);
                        break;
                    }
                    case 2: {
                        if (!((double)distance >= Double.parseDouble(pp[1]) * 1000.0)) break;
                        this.local.remove(p);
                        break;
                    }
                    case 3: {
                        if ((double)distance != Double.parseDouble(pp[1]) * 1000.0) break;
                        this.local.remove(p);
                        break;
                    }
                    case 4: {
                        if (!((double)distance < Double.parseDouble(pp[1]) * 1000.0)) break;
                        this.local.remove(p);
                        break;
                    }
                    case 5: {
                        if (!((double)distance > Double.parseDouble(pp[1]) * 1000.0)) break;
                        this.local.remove(p);
                    }
                }
            }
        }
        this.first = false;
    }

    public Set<Parcel> buildLocation() {
        if (this.first) {
            this.local = this.allocator.parcels();
        }
        return this.local;
    }

    public boolean hasError() {
        return this.nbErrors > 0;
    }

    public String toStringError() {
        this.error.append(" " + this.nbErrors + " errors.");
        return this.error.toString();
    }

    @Override
    public void visitErrorNode(@NotNull ErrorNode node) {
        ++this.nbErrors;
        this.error.append(node.getText() + " ");
    }
}

