/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model;

import com.csvreader.CsvReader;
import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocator;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.simul.CoverLocationModel;
import fr.inra.sad.bagap.apiland.capfarm.simul.MemoryCoverLocationModel;
import fr.inra.sad.bagap.apiland.core.composition.AttributeType;
import fr.inra.sad.bagap.apiland.core.composition.DynamicAttributeType;
import fr.inra.sad.bagap.apiland.core.element.type.DynamicElementTypeFactory;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.Interval;
import java.io.IOException;
import java.util.ArrayList;

public class MemoryFactory {
    public static void init(CoverLocationModel model, Instant t, String farmFolder, String method) {
        CoverAllocator farm = model.getCoverAllocator();
        if (farm.hasMemory()) {
            int memory = farm.getMemory();
            try {
                String memoryFile = farmFolder + "/" + farm.getCode() + "/" + farm.getFarmingSystem() + "/" + farm.getCode() + "_memory.csv";
                if (memory == 0) {
                    CsvReader cr = new CsvReader(memoryFile);
                    cr.setDelimiter(';');
                    cr.readHeaders();
                    if (method == null || method.equalsIgnoreCase("")) {
                        ArrayList<Integer> memories = new ArrayList<Integer>();
                        while (cr.readRecord()) {
                            memories.add(Integer.parseInt(cr.get("memory")));
                        }
                        memory = (Integer)memories.get(new Double(Math.random() * (double)memories.size()).intValue());
                    } else if (method.startsWith("max")) {
                        method = method.replace("max(", "").replace(")", "");
                        int max = -1;
                        while (cr.readRecord()) {
                            int profit = Integer.parseInt(cr.get("profit"));
                            if (profit <= max) continue;
                            memory = Integer.parseInt(cr.get("memory"));
                            max = profit;
                        }
                        System.out.println(farm.getCode() + " " + memory + " " + max);
                    } else if (method.startsWith("selected")) {
                        String[] farms;
                        method = method.replace("selected(", "").replace(")", "");
                        for (String f : farms = method.split(":")) {
                            if (!f.startsWith(farm.getCode() + "=")) continue;
                            memory = Integer.parseInt(f.replace(farm.getCode() + "=", ""));
                        }
                    } else {
                        throw new IllegalArgumentException("method " + method + " is taken into account yet");
                    }
                    farm.setMemory(memory);
                    cr.close();
                }
                AttributeType type = DynamicElementTypeFactory.createAttributeType("memory", Interval.class, CoverUnit.class);
                CsvReader cr = new CsvReader(memoryFile);
                cr.setDelimiter(';');
                cr.readHeaders();
                while (cr.readRecord()) {
                    if (Integer.parseInt(cr.get("memory")) != memory) continue;
                    MemoryFactory.initMemoryFile((MemoryCoverLocationModel)model, t, (DynamicAttributeType)type, farmFolder + "/" + farm.getCode() + "/" + farm.getFarmingSystem() + "/" + cr.get("file"));
                    break;
                }
                cr.close();
            }
            catch (CsvReader.CatastrophicException | CsvReader.FinalizedException | IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void initMemoryFile(MemoryCoverLocationModel model, Instant t, DynamicAttributeType type, String memoryFile) {
        try {
            CsvReader cr = new CsvReader(memoryFile);
            cr.setDelimiter(';');
            cr.readHeaders();
            while (cr.readRecord()) {
                String parcel = cr.get("parcel");
                model.initParcel(parcel, type);
                String[] sequence = cr.get("seq_cover").replaceAll(" ", "").split("-");
                Instant year = t;
                for (String cover : sequence) {
                    int nb = 1;
                    if (cover.contains("(")) {
                        String[] infos = cover.replace(")", "").split("\\(");
                        cover = infos[0];
                        nb = Integer.parseInt(infos[1]);
                    }
                    model.setCover(parcel, (CoverUnit)Cover.get(cover), year);
                    year = Instant.get(year.dayOfMonth(), year.month(), year.year() + nb);
                }
            }
            cr.close();
        }
        catch (CsvReader.CatastrophicException | CsvReader.FinalizedException | IOException e) {
            e.printStackTrace();
        }
    }
}

