/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model;

import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.Covering;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.GenericCoverAllocationConstraint;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class GenericFarmingSystem
implements Covering {
    private String name;
    private Set<Cover> covers;
    private Map<String, GenericCoverAllocationConstraint> constraints;

    public GenericFarmingSystem(String name) {
        this.name = name;
        this.covers = new TreeSet<Cover>();
        this.constraints = new TreeMap<String, GenericCoverAllocationConstraint>();
    }

    public String toString() {
        return this.getName();
    }

    public void display() {
        for (GenericCoverAllocationConstraint gc : this.constraints.values()) {
            System.out.println(gc);
        }
    }

    public String getName() {
        return this.name;
    }

    public Set<Cover> getCovers() {
        return this.covers;
    }

    public Collection<GenericCoverAllocationConstraint> getConstraints() {
        return this.constraints.values();
    }

    public Collection<GenericCoverAllocationConstraint> getConstraintsMultipleCovers() {
        TreeSet<GenericCoverAllocationConstraint> cons = new TreeSet<GenericCoverAllocationConstraint>();
        for (GenericCoverAllocationConstraint gc : this.constraints.values()) {
            if (gc.getCovers().length <= 1 && !gc.getCovers()[0].equalsIgnoreCase("ALL") && !gc.getCovers()[0].equalsIgnoreCase("EACH")) continue;
            cons.add(gc);
        }
        return cons;
    }

    public Collection<GenericCoverAllocationConstraint> getConstraints(Cover c) {
        TreeSet<GenericCoverAllocationConstraint> cons = new TreeSet<GenericCoverAllocationConstraint>();
        for (GenericCoverAllocationConstraint gc : this.constraints.values()) {
            if (gc.getCovers().length != 1 || !gc.getCovers()[0].equals(c.getCode())) continue;
            cons.add(gc);
        }
        return cons;
    }

    @Override
    public void addCover(Cover c) {
        this.covers.add(c);
    }

    @Override
    public void addCovers(Collection<Cover> covers) {
        this.covers.addAll(covers);
    }

    public void addConstraint(GenericCoverAllocationConstraint constraint) {
        if (!this.constraints.containsKey(constraint.getCode())) {
            this.constraints.put(constraint.getCode(), constraint);
            return;
        }
        throw new IllegalArgumentException("constraint code '" + constraint.getCode() + "' already exists");
    }
}

