/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocator;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverGroup;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.FarmingSystem;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.CoverAllocationConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.FarmTerritory;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class Farm
implements CoverAllocator {
    private String code;
    private FarmingSystem system;
    private FarmTerritory territory;
    private String historic;
    int memory = 0;
    boolean hasMemory = false;
    private String solutionFile;
    private Map<Parcel, CoverUnit> solution;

    public Farm(String code) {
        this.code = code;
        this.system = new FarmingSystem(this);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public void addCover(Cover c) {
        this.system.addCover(c);
    }

    @Override
    public void addCovers(Collection<Cover> covers) {
        this.system.addCovers(covers);
    }

    @Override
    public FarmingSystem getFarmingSystem() {
        return this.system;
    }

    @Override
    public FarmTerritory getTerritory() {
        return this.territory;
    }

    public void setFarmingSystem(FarmingSystem system) {
        this.system = system;
    }

    public void setTerritory(FarmTerritory territory) {
        this.territory = territory;
    }

    @Override
    public Set<CoverAllocationConstraint<?, ?>> getConstraints() {
        return this.system.getConstraints();
    }

    @Override
    public int totalParcelsArea() {
        return this.territory.totalParcelsArea();
    }

    @Override
    public int totalEdgesLength() {
        return this.territory.totalEdgesLength();
    }

    @Override
    public int[] edgesLength() {
        return this.territory.edgesLength();
    }

    @Override
    public Set<Parcel> parcels() {
        return this.territory.parcels();
    }

    @Override
    public Parcel parcel(String id) {
        return (Parcel)this.territory.get(id);
    }

    @Override
    public Set<CoverUnit> coverUnits() {
        return this.system.coverUnits();
    }

    @Override
    public Set<CoverGroup> coverGroups() {
        return this.system.coverGroups();
    }

    @Override
    public void clearParcels() {
        this.territory.clearParcels();
        this.memory = 0;
    }

    @Override
    public void addConstraint(CoverAllocationConstraint<?, ?> constraint) {
        this.system.addConstraint(constraint);
        constraint.setAllocator(this);
    }

    @Override
    public int getDistanceFromFacilitiesToParcel(String facilities, Parcel parcel) {
        return this.territory.getDistanceFromFacilitiesToParcel(facilities, parcel);
    }

    @Override
    public int getArea() {
        return this.territory.totalParcelsArea();
    }

    @Override
    public CoverUnit getCoverUnit(String code) {
        return this.system.getCoverUnit(code);
    }

    @Override
    public void clearFarmingSystem() {
        this.system = new FarmingSystem(this);
    }

    public void setHistoric(String historic) {
        this.historic = historic;
    }

    public String getHistoric() {
        return this.historic;
    }

    public boolean hasHistoric() {
        return this.historic != null;
    }

    @Override
    public void checkFarmingSystem(Instant start, Instant end, boolean verbose) {
        for (CoverAllocationConstraint<?, ?> ca : this.system.getConstraints()) {
            ca.check(start, end, true);
        }
    }

    @Override
    public void setMemory(int memory) {
        this.memory = memory;
    }

    @Override
    public void setMemory(boolean memory) {
        this.hasMemory = memory;
    }

    @Override
    public boolean hasMemory() {
        return this.hasMemory;
    }

    @Override
    public int getMemory() {
        return this.memory;
    }

    @Override
    public void setSolution(Map<Parcel, CoverUnit> solution) {
        this.solution = solution;
    }

    public void setSolution(String solutionfixFile) {
        this.solutionFile = solutionfixFile;
    }

    public String getFixFile() {
        return this.solutionFile;
    }

    public boolean hasSolution() {
        return this.solutionFile != null;
    }

    @Override
    public Map<Parcel, CoverUnit> getSolution() {
        return this.solution;
    }
}

