/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.csp;

import fr.inra.sad.bagap.apiland.capfarm.csp.AbstractProblem;
import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocator;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverGroup;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.CoverAllocationConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.core.composition.DynamicAttribute;
import fr.inra.sad.bagap.apiland.core.composition.TemporalValue;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.Map;
import java.util.TreeMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.constraints.LCF;
import org.chocosolver.solver.search.loop.monitors.SMF;
import org.chocosolver.solver.search.strategy.ISF;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.search.strategy.strategy.IntStrategy;
import org.chocosolver.solver.search.strategy.strategy.StrategiesSequencer;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.VF;
import org.chocosolver.util.tools.ArrayUtils;

public class CoverAllocationProblem
extends AbstractProblem {
    private CoverAllocator allocator;
    private Instant t;
    private Instant[] starts;
    protected BoolVar[][] coversAndParcels;
    private BoolVar[][] parcelsAndCovers;
    protected BoolVar[] parcelsImplantedCoverContinue;
    private Map<CoverUnit, Integer> covers;
    private Map<Parcel, Integer> parcels;
    private Map<CoverGroup, Integer> groups;
    private TemporalValue<CoverUnit>[] previous;
    private TemporalValue<CoverUnit>[] first;

    public CoverAllocationProblem(CoverAllocator allocator, Instant t) {
        this.allocator = allocator;
        this.t = t;
    }

    protected Instant time() {
        return this.t;
    }

    @Override
    protected void createSolver() {
        this.solver = new Solver("allocateur de cultures annuelles");
    }

    @Override
    protected void buildModel() {
        this.buildVariables();
        this.structureInitialisation();
        this.postConstraints();
    }

    /*
     * WARNING - void declaration
     */
    protected void buildVariables() {
        this.covers = new TreeMap<CoverUnit, Integer>();
        int ic = 0;
        for (CoverUnit coverUnit : this.allocator.coverUnits()) {
            this.covers.put(coverUnit, ic++);
        }
        this.groups = new TreeMap<CoverGroup, Integer>();
        int ig = 0;
        for (CoverGroup g : this.allocator.coverGroups()) {
            this.groups.put(g, ig++);
        }
        this.parcels = new TreeMap<Parcel, Integer>();
        boolean bl = false;
        for (Parcel p : this.allocator.parcels()) {
            void var3_7;
            this.parcels.put(p, (int)(++var3_7));
        }
        this.parcelsAndCovers = new BoolVar[this.allocator.parcels().size()][this.allocator.coverUnits().size()];
        this.coversAndParcels = new BoolVar[this.allocator.coverUnits().size()][this.allocator.parcels().size()];
        this.parcelsImplantedCoverContinue = new BoolVar[this.allocator.parcels().size()];
        this.previous = new TemporalValue[this.allocator.parcels().size()];
        this.first = new TemporalValue[this.allocator.parcels().size()];
        this.starts = new Instant[this.allocator.parcels().size()];
        for (Parcel p : this.parcels.keySet()) {
            int n = this.parcels.get(p);
            this.previous[n] = ((DynamicAttribute)p.getAttribute("cover")).getLast();
            this.first[n] = ((DynamicAttribute)p.getAttribute("cover")).getFirst();
            this.starts[n] = ((DynamicAttribute)p.getAttribute("cover")).getTime().start();
        }
    }

    protected void structureInitialisation() {
        for (Parcel p : this.parcels.keySet()) {
            int ip = this.parcels.get(p);
            for (CoverUnit c : this.covers.keySet()) {
                int ic = this.covers.get(c);
                this.coversAndParcels[ic][ip] = VF.bool((String)("c_" + ic + "_p_" + ip), (Solver)this.solver);
                this.parcelsAndCovers[ip][ic] = this.coversAndParcels[ic][ip];
            }
            this.solver.post(ICF.sum((BoolVar[])this.parcelsAndCovers[ip], (IntVar)VF.one((Solver)this.solver)));
            for (CoverGroup g : this.groups.keySet()) {
                BoolVar[] max = new BoolVar[g.size()];
                int i = 0;
                for (CoverUnit c : g) {
                    max[i] = this.covers.containsKey(c) ? this.coversAndParcels[this.covers.get(c)][ip] : VF.zero((Solver)this.solver);
                    ++i;
                }
            }
            this.parcelsImplantedCoverContinue[ip] = VF.bool((String)("time_p_" + ip), (Solver)this.solver);
            if (this.previous[ip] != null) {
                LCF.ifThen((BoolVar)this.parcelsImplantedCoverContinue[ip], (Constraint)ICF.arithm((IntVar)this.coversAndParcels[this.covers.get(this.previous[ip].getValue())][ip], (String)"=", (int)1));
                continue;
            }
            this.solver.post(ICF.arithm((IntVar)this.parcelsImplantedCoverContinue[ip], (String)"=", (int)0));
        }
    }

    protected void postConstraints() {
        for (CoverAllocationConstraint<?, ?> cst : this.allocator.getConstraints()) {
            if (cst.checkOnly()) continue;
            cst.post(this);
        }
    }

    @Override
    protected void configureSearch() {
        long r = new Double(Math.random() * 1.0E9).longValue();
        IntStrategy as1 = ISF.random((IntVar[])((IntVar[])ArrayUtils.append((Object[][])this.coversAndParcels)), (long)r);
        IntStrategy as2 = ISF.random((IntVar[])this.parcelsImplantedCoverContinue, (long)r);
        this.solver.set(new AbstractStrategy[]{ISF.lastConflict((Solver)this.solver, (AbstractStrategy)new StrategiesSequencer(new AbstractStrategy[]{as1, as2}))});
        SMF.limitFail((Solver)this.solver, (long)500L);
    }

    @Override
    protected boolean solve() {
        if (this.solver.findSolution()) {
            block0: for (Parcel p : this.parcels.keySet()) {
                int ip = this.parcels.get(p);
                if (this.parcelsImplantedCoverContinue[ip].getValue() != 0) continue;
                for (Cover cover : this.covers.keySet()) {
                    int ic = this.covers.get(cover);
                    if (this.coversAndParcels[ic][ip].getValue() != 1) continue;
                    p.getAttribute("cover").setValue(this.t, cover);
                    continue block0;
                }
            }
            return true;
        }
        return false;
    }

    public Solver solver() {
        return this.solver;
    }

    public CoverAllocator allocator() {
        return this.allocator;
    }

    public Map<Parcel, Integer> parcels() {
        return this.parcels;
    }

    public Map<CoverUnit, Integer> covers() {
        return this.covers;
    }

    public Map<CoverGroup, Integer> groups() {
        return this.groups;
    }

    public BoolVar[] coversAndParcels(int ic) {
        return this.coversAndParcels[ic];
    }

    public BoolVar coversAndParcels(int ic, int ip) {
        return this.coversAndParcels[ic][ip];
    }

    public BoolVar parcelsImplantedCoverContinue(int ip) {
        return this.parcelsImplantedCoverContinue[ip];
    }

    public Instant getTime() {
        return this.t;
    }

    public TemporalValue<CoverUnit> previous(int ip) {
        return this.previous[ip];
    }

    public TemporalValue<CoverUnit> first(int ip) {
        return this.first[ip];
    }

    public Instant starts(int ip) {
        return this.starts[ip];
    }
}

