/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.vector.metric;

import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import fr.inra.sad.bagap.apiland.analysis.VariableManager;
import fr.inra.sad.bagap.apiland.analysis.vector.metric.VectorMetric;
import fr.inra.sad.bagap.apiland.core.composition.Composition;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.Set;

public class SurfaceProportionMetric
extends VectorMetric {
    private Object code;

    public SurfaceProportionMetric(Object code) {
        super(VariableManager.get("P_" + code));
        this.code = code;
    }

    @Override
    public void doCalculate(Point point, Set<Polygon> polygons, Instant t) {
        double area = 0.0;
        double total = 0.0;
        for (Polygon p : polygons) {
            if (!((Composition)p.getUserData()).getAttribute("cover").isActive(t)) continue;
            total += p.getArea();
            if (!((Composition)p.getUserData()).getAttribute("cover").getValue(t).equals(this.code)) continue;
            area += p.getArea();
        }
        this.value = area / total;
        if (Double.isNaN(this.value)) {
            this.value = Raster.getNoDataValue();
        }
    }
}

