/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.vector.metric;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import fr.inra.sad.bagap.apiland.analysis.VariableManager;
import fr.inra.sad.bagap.apiland.analysis.vector.metric.VectorMetric;
import fr.inra.sad.bagap.apiland.core.composition.Composition;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.HashSet;
import java.util.Set;

public class HeterogeneousEdgeLengthMetric
extends VectorMetric {
    private String attribute;

    public HeterogeneousEdgeLengthMetric(String attribute) {
        super(VariableManager.get("E_Hete"));
        this.attribute = attribute;
    }

    @Override
    public void doCalculate(Point point, Set<Polygon> polygons, Instant t) {
        this.value = 0.0;
        HashSet<Polygon> ever = new HashSet<Polygon>();
        for (Polygon p1 : polygons) {
            ever.add(p1);
            Object o1 = ((Composition)p1.getUserData()).getAttribute(this.attribute).getValue(t);
            for (Polygon p2 : polygons) {
                Object o2 = ((Composition)p2.getUserData()).getAttribute(this.attribute).getValue(t);
                if (ever.contains(p2) || o1.equals(o2) || !p1.intersects((Geometry)p2)) continue;
                Geometry i = p1.intersection((Geometry)p2);
                this.value += i.getLength();
            }
        }
        if (Double.isNaN(this.value)) {
            this.value = Raster.getNoDataValue();
        }
    }
}

