/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.vector.metric;

import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import fr.inra.sad.bagap.apiland.analysis.VariableManager;
import fr.inra.sad.bagap.apiland.analysis.vector.metric.VectorMetric;
import fr.inra.sad.bagap.apiland.core.composition.Composition;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.Set;

public class DispersionMetric
extends VectorMetric {
    private Object code;

    public DispersionMetric(Object code) {
        super(VariableManager.get("D_" + code));
        this.code = code;
    }

    @Override
    public void doCalculate(Point point, Set<Polygon> polygons, Instant t) {
        this.value = 0.0;
        double xc = 0.0;
        double yc = 0.0;
        double poids = 0.0;
        int nb = 0;
        for (Polygon p : polygons) {
            if (!((Composition)p.getUserData()).getAttribute("cover").isActive(t) || !((Composition)p.getUserData()).getAttribute("cover").getValue(t).equals(this.code)) continue;
            xc += p.getCentroid().getCoordinate().x * p.getArea();
            yc += p.getCentroid().getCoordinate().y * p.getArea();
            poids += p.getArea();
            ++nb;
        }
        if (nb > 1) {
            xc /= poids;
            yc /= poids;
            for (Polygon p : polygons) {
                if (!((Composition)p.getUserData()).getAttribute("cover").isActive(t) || !((Composition)p.getUserData()).getAttribute("cover").getValue(t).equals(this.code)) continue;
                double x = p.getCentroid().getCoordinate().x;
                double y = p.getCentroid().getCoordinate().y;
                double d = Math.sqrt(Math.pow(x - xc, 2.0) + Math.pow(y - yc, 2.0));
                this.value += Math.pow(d, 2.0) / (double)(nb - 1);
            }
            this.value = Math.sqrt(this.value);
        }
        if (Double.isNaN(this.value) || this.value == 0.0) {
            this.value = Raster.getNoDataValue();
        }
    }
}

