/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.vector.metric;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import fr.inra.sad.bagap.apiland.analysis.VariableManager;
import fr.inra.sad.bagap.apiland.analysis.vector.metric.VectorMetric;
import fr.inra.sad.bagap.apiland.core.composition.Composition;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.HashSet;
import java.util.Set;

public class CoupleEdgeLengthMetric
extends VectorMetric {
    private String attribute;
    private Object code1;
    private Object code2;

    public CoupleEdgeLengthMetric(String attribute, Object code1, Object code2) {
        super(VariableManager.get("E_" + code1 + "-" + code2));
        this.attribute = attribute;
        this.code1 = code1;
        this.code2 = code2;
    }

    @Override
    public void doCalculate(Point point, Set<Polygon> polygons, Instant t) {
        this.value = 0.0;
        HashSet<Polygon> ever = new HashSet<Polygon>();
        for (Polygon p1 : polygons) {
            if (!((Composition)p1.getUserData()).getAttribute(this.attribute).isActive(t) || !((Composition)p1.getUserData()).getAttribute(this.attribute).getValue(t).equals(this.code1)) continue;
            ever.add(p1);
            for (Polygon p2 : polygons) {
                if (!((Composition)p2.getUserData()).getAttribute(this.attribute).isActive(t) || !((Composition)p2.getUserData()).getAttribute(this.attribute).getValue(t).equals(this.code2) || ever.contains(p2) || !p1.intersects((Geometry)p2)) continue;
                Geometry i = p1.intersection((Geometry)p2);
                this.value += i.getLength();
            }
        }
        if (Double.isNaN(this.value)) {
            this.value = Raster.getNoDataValue();
        }
    }
}

