/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.util;

import au.com.bytecode.opencsv.CSVReader;
import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import fr.inra.sad.bagap.apiland.core.element.manager.DynamicLayerFactory;
import fr.inra.sad.bagap.apiland.core.element.manager.Tool;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class SpatialCsvManager {
    public static void exportAsciiGrid(String csv, String folder, String outputName, Matrix matrix) {
        SpatialCsvManager.exportAsciiGrid(csv, folder, outputName, null, matrix.width(), matrix.height(), matrix.minX(), matrix.minY(), 1, matrix.cellsize(), matrix.noDataValue());
    }

    public static void exportAsciiGridAndVisualize(String csv, String folder, String outputName, Matrix matrix) {
        SpatialCsvManager.exportAsciiGrid(csv, folder, outputName, matrix);
        MatrixManager.visualize(folder);
    }

    public static void exportAsciiGrid(String csv, String folder, String outputName, Matrix matrix, int delta) {
        SpatialCsvManager.exportAsciiGrid(csv, folder, outputName, null, matrix.width(), matrix.height(), matrix.minX(), matrix.minY(), delta, matrix.cellsize(), matrix.noDataValue());
    }

    public static void exportAsciiGridAndVisualize(String csv, String folder, String outputName, Matrix matrix, int delta) {
        SpatialCsvManager.exportAsciiGrid(csv, folder, outputName, matrix, delta);
        MatrixManager.visualize(folder);
    }

    public static void exportAsciiGrid(String csv, String folder, String outputName, Set<String> metrics, Matrix matrix, int delta) {
        SpatialCsvManager.exportAsciiGrid(csv, folder, outputName, metrics, matrix.width(), matrix.height(), matrix.minX(), matrix.minY(), delta, matrix.cellsize(), matrix.noDataValue());
    }

    public static void exportAsciiGridAndVisualize(String csv, String folder, String outputName, Set<String> metrics, Matrix matrix, int delta) {
        SpatialCsvManager.exportAsciiGrid(csv, folder, outputName, metrics, matrix, delta);
        MatrixManager.visualize(folder);
    }

    public static void exportAsciiGrid(Set<String> csvFiles, String folder, String outputName, Set<String> metrics, int width, int height, double minX, double minY, int delta, double cellSize, int noDataValue) {
        for (String csv : csvFiles) {
            String name = new File(csv).getName().replace(".csv", "");
            SpatialCsvManager.exportAsciiGrid(csv, folder + "/" + name + "_", outputName, metrics, width, height, minX, minY, delta, cellSize, noDataValue);
        }
    }

    public static void exportAsciiGridAndVisualize(Set<String> csvFiles, String folder, String outputName, Set<String> metrics, int width, int height, double minX, double minY, int delta, double cellSize, int noDataValue) {
        SpatialCsvManager.exportAsciiGrid(csvFiles, folder, outputName, metrics, width, height, minX, minY, delta, cellSize, noDataValue);
        MatrixManager.visualize(folder);
    }

    public static void exportAsciiGrid2(String csv, String folder, String outputName, Set<String> metrics, int width, int height, double minX, double minY, int delta, double cellSize, int noDataValue) {
        try {
            HashMap<Object, BufferedWriter> writers = new HashMap<Object, BufferedWriter>();
            CsvReader cr = new CsvReader(csv);
            cr.setDelimiter(';');
            cr.readHeaders();
            if (metrics != null && metrics.size() != 0) {
                for (String metric : metrics) {
                    for (String header : cr.getHeaders()) {
                        if (!header.contains(metric)) continue;
                        writers.put(header, new BufferedWriter(new FileWriter(folder + header + ".asc")));
                    }
                }
            } else {
                for (String header : cr.getHeaders()) {
                    if (header.equalsIgnoreCase("X") || header.equalsIgnoreCase("Y")) continue;
                    writers.put(header, new BufferedWriter(new FileWriter(folder + (String)header + ".asc")));
                }
            }
            for (BufferedWriter w : writers.values()) {
                int nc = new Double(width / delta).intValue();
                if (width % delta != 0) {
                    ++nc;
                }
                w.write("ncols " + nc + "\n");
                int nr = new Double(height / delta).intValue();
                if (height % delta != 0) {
                    ++nr;
                }
                w.write("nrows " + nr + "\n");
                w.write("xllcorner " + minX + "\n");
                w.write("yllcorner " + minY + "\n");
                w.write("cellsize " + (double)delta * cellSize + "\n");
                w.write("NODATA_value " + noDataValue + "\n");
            }
            double y = -1.0;
            while (cr.readRecord()) {
                double ytemp = Double.parseDouble(cr.get("Y"));
                if (y == -1.0) {
                    for (Map.Entry e : writers.entrySet()) {
                        ((BufferedWriter)e.getValue()).write(cr.get((String)e.getKey()) + "");
                    }
                    y = ytemp;
                    continue;
                }
                if (ytemp != y) {
                    for (Map.Entry e : writers.entrySet()) {
                        ((BufferedWriter)e.getValue()).write("\n" + cr.get((String)e.getKey()));
                    }
                    y = ytemp;
                    continue;
                }
                for (Map.Entry e : writers.entrySet()) {
                    ((BufferedWriter)e.getValue()).write(" " + cr.get((String)e.getKey()));
                }
            }
            for (Map.Entry e : writers.entrySet()) {
                ((BufferedWriter)e.getValue()).write(10);
                ((BufferedWriter)e.getValue()).close();
            }
            cr.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (CsvReader.FinalizedException ex) {
            ex.printStackTrace();
        }
        catch (CsvReader.CatastrophicException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportAsciiGrid(String csv, String folder, String outputAsc, Set<String> metrics, int width, int height, double minX, double minY, int delta, double cellSize, int noDataValue) {
        try {
            HashMap<Object, BufferedWriter> writers = new HashMap<Object, BufferedWriter>();
            String name = new File(csv).getName().replace(".csv", "");
            CsvReader cr = new CsvReader(csv);
            cr.setDelimiter(';');
            cr.readHeaders();
            if (metrics.size() == 1 && outputAsc != null) {
                for (String header : cr.getHeaders()) {
                    if (!header.contains(metrics.iterator().next())) continue;
                    writers.put(header, new BufferedWriter(new FileWriter(outputAsc)));
                }
            } else if (metrics != null && metrics.size() != 0) {
                for (String metric : metrics) {
                    for (String header : cr.getHeaders()) {
                        if (!header.contains(metric)) continue;
                        writers.put(header, new BufferedWriter(new FileWriter(folder + name + "_" + header + ".asc")));
                    }
                }
            } else {
                for (String header : cr.getHeaders()) {
                    if (header.equalsIgnoreCase("X") || header.equalsIgnoreCase("Y")) continue;
                    writers.put(header, new BufferedWriter(new FileWriter(folder + name + "_" + (String)header + ".asc")));
                }
            }
            for (BufferedWriter w : writers.values()) {
                int nc = new Double(width / delta).intValue();
                if (width % delta != 0) {
                    ++nc;
                }
                w.write("ncols " + nc);
                w.newLine();
                int nr = new Double(height / delta).intValue();
                if (height % delta != 0) {
                    ++nr;
                }
                w.write("nrows " + nr);
                w.newLine();
                w.write("xllcorner " + minX);
                w.newLine();
                w.write("yllcorner " + minY);
                w.newLine();
                w.write("cellsize " + (double)delta * cellSize);
                w.newLine();
                w.write("NODATA_value " + noDataValue);
                w.newLine();
            }
            cr.readRecord();
            double x = Double.parseDouble(cr.get("X"));
            double y = Double.parseDouble(cr.get("Y"));
            for (double nextY = minY + (double)(height - 1) * cellSize + cellSize / 2.0; nextY >= minY; nextY -= cellSize) {
                for (double nextX = minX + cellSize - cellSize / 2.0; nextX < minX + (double)width * cellSize; nextX += cellSize) {
                    if (Math.abs(y - nextY) < cellSize / 2.0 && Math.abs(x - nextX) < cellSize / 2.0) {
                        for (Map.Entry e : writers.entrySet()) {
                            ((BufferedWriter)e.getValue()).write(cr.get((String)e.getKey()) + " ");
                        }
                        if (!cr.readRecord()) continue;
                        x = Double.parseDouble(cr.get("X"));
                        y = Double.parseDouble(cr.get("Y"));
                        continue;
                    }
                    for (Map.Entry e : writers.entrySet()) {
                        ((BufferedWriter)e.getValue()).write(Raster.getNoDataValue() + " ");
                    }
                }
                for (Map.Entry e : writers.entrySet()) {
                    ((BufferedWriter)e.getValue()).newLine();
                }
            }
            for (Map.Entry e : writers.entrySet()) {
                ((BufferedWriter)e.getValue()).close();
                try {
                    Tool.copy(DynamicLayerFactory.class.getResourceAsStream("lambert93.prj"), folder + name + "_" + (String)e.getKey() + ".prj");
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            cr.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (CsvReader.FinalizedException ex) {
            ex.printStackTrace();
        }
        catch (CsvReader.CatastrophicException ex) {
            ex.printStackTrace();
        }
    }

    public static void sort(String csv) {
        try {
            String[] line;
            CSVReader reader = new CSVReader((Reader)new FileReader(csv), ';');
            String[] header = reader.readNext();
            TreeSet<String[]> set = new TreeSet<String[]>(new Comparator<String[]>(){

                @Override
                public int compare(String[] line1, String[] line2) {
                    int y = line1[1].compareTo(line2[1]);
                    if (y < 0) {
                        return 1;
                    }
                    if (y > 0) {
                        return -1;
                    }
                    int x = line1[0].compareTo(line2[0]);
                    if (x < 0) {
                        return -1;
                    }
                    if (x > 0) {
                        return 1;
                    }
                    return 0;
                }
            });
            while ((line = reader.readNext()) != null) {
                set.add(line);
            }
            reader.close();
            File f = new File(csv);
            String name = f.getName().replace(".csv", "");
            CsvWriter cw = new CsvWriter(f.getParent() + "/" + name + "_sort.csv");
            cw.setDelimiter(';');
            for (String h : header) {
                cw.write(h);
            }
            cw.endRecord();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String[] l;
                for (String c : l = (String[])iterator.next()) {
                    cw.write(c);
                }
                cw.endRecord();
            }
            cw.close();
            new File(f.getParent() + "/" + name + "_sort.csv").renameTo(f);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (CsvWriter.FinalizedException e) {
            e.printStackTrace();
        }
    }

    public static void exportFromAsciiGrid(String ascii, String csv) {
        String name = new File(ascii).getName().replace(".asc", "");
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(ascii));
            String line = br.readLine();
            String sep = String.valueOf(line.charAt(5));
            String[] s = line.split(sep);
            int width = Integer.parseInt(s[s.length - 1]);
            s = br.readLine().split(sep);
            int height = Integer.parseInt(s[s.length - 1]);
            s = br.readLine().split(sep);
            double minx = Double.parseDouble(s[s.length - 1]);
            s = br.readLine().split(sep);
            double miny = Double.parseDouble(s[s.length - 1]);
            s = br.readLine().split(sep);
            double cellsize = Double.parseDouble(s[s.length - 1]);
            double maxx = minx + (double)width * cellsize;
            double maxy = miny + (double)height * cellsize;
            s = br.readLine().split(sep);
            int noDataValue = Integer.parseInt(s[s.length - 1]);
            CsvWriter cw = new CsvWriter(csv);
            cw.setDelimiter(';');
            cw.write("X");
            cw.write("Y");
            cw.write(name);
            cw.endRecord();
            double y = maxy;
            while (br.ready()) {
                double x = minx;
                for (String v : s = br.readLine().split(" ")) {
                    if (Double.parseDouble(v) != (double)noDataValue) {
                        cw.write(x + "");
                        cw.write(y + "");
                        cw.write(v);
                        cw.endRecord();
                    }
                    x += cellsize;
                }
                y -= cellsize;
            }
            cw.close();
            br.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (CsvWriter.FinalizedException e) {
            e.printStackTrace();
        }
    }

    public static void exportFromAsciiGrid(Set<String> asciis, String csv) {
        try {
            TreeMap<String, BufferedReader> readers = new TreeMap<String, BufferedReader>();
            for (String a : asciis) {
                readers.put(new File(a).getName().replace(".asc", ""), new BufferedReader(new FileReader(a)));
            }
            int width = 0;
            int noDataValue = -1;
            double minx = 0.0;
            double maxy = 0.0;
            double cellsize = 0.0;
            for (Object br : readers.values()) {
                String line = ((BufferedReader)br).readLine();
                String sep = String.valueOf(line.charAt(5));
                String[] s = line.split(sep);
                width = Integer.parseInt(s[s.length - 1]);
                s = ((BufferedReader)br).readLine().split(sep);
                int height = Integer.parseInt(s[s.length - 1]);
                s = ((BufferedReader)br).readLine().split(sep);
                minx = Double.parseDouble(s[s.length - 1]) + cellsize / 2.0;
                s = ((BufferedReader)br).readLine().split(sep);
                double miny = Double.parseDouble(s[s.length - 1]) - cellsize / 2.0;
                s = ((BufferedReader)br).readLine().split(sep);
                cellsize = Double.parseDouble(s[s.length - 1]);
                double maxx = minx + (double)width * cellsize;
                maxy = miny + (double)height * cellsize;
                s = ((BufferedReader)br).readLine().split(sep);
                noDataValue = Integer.parseInt(s[s.length - 1]);
            }
            CsvWriter cw = new CsvWriter(csv);
            cw.setDelimiter(';');
            cw.write("X");
            cw.write("Y");
            for (String n : readers.keySet()) {
                cw.write(n);
            }
            cw.endRecord();
            double y = maxy;
            TreeMap lines = new TreeMap();
            while (((BufferedReader)readers.values().iterator().next()).ready()) {
                double x = minx;
                lines.clear();
                for (Map.Entry e : readers.entrySet()) {
                    lines.put(e.getKey(), ((BufferedReader)e.getValue()).readLine().split(" "));
                }
                for (int i = 0; i < width; ++i) {
                    boolean ok = true;
                    for (String[] line : lines.values()) {
                        if (Double.parseDouble(line[i]) != (double)noDataValue) continue;
                        ok = false;
                        break;
                    }
                    if (ok) {
                        cw.write(x + "");
                        cw.write(y + "");
                        for (String[] line : lines.values()) {
                            cw.write(line[i]);
                        }
                        cw.endRecord();
                    }
                    x += cellsize;
                }
                y -= cellsize;
            }
            cw.close();
            for (BufferedReader br : readers.values()) {
                br.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CsvWriter.FinalizedException e) {
            e.printStackTrace();
        }
    }
}

