/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Lineal;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.Puntal;
import com.vividsolutions.jts.geom.prep.PreparedLineString;
import com.vividsolutions.jts.geom.prep.PreparedPoint;
import com.vividsolutions.jts.geom.prep.PreparedPolygon;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import fr.inra.sad.bagap.apiland.analysis.matrix.util.AddNoDataValueAsciiGridCleaner;
import fr.inra.sad.bagap.apiland.analysis.matrix.util.AsciiGridCleaner;
import fr.inra.sad.bagap.apiland.analysis.matrix.util.DecimalCharAsciiGridCleaner;
import fr.inra.sad.bagap.apiland.analysis.matrix.util.ExportAsciiGridFromShapefileAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.util.IntegerAsciiGridCleaner;
import fr.inra.sad.bagap.apiland.analysis.matrix.util.NoDataValueAsciiGridCleaner;
import fr.inra.sad.bagap.apiland.analysis.matrix.util.SearchAndReplaceAsciiGridCleaner;
import fr.inra.sad.bagap.apiland.analysis.matrix.util.SpaceAsciiGridCleaner;
import fr.inra.sad.bagap.apiland.core.element.DynamicElement;
import fr.inra.sad.bagap.apiland.core.element.DynamicFeature;
import fr.inra.sad.bagap.apiland.core.element.DynamicLayer;
import fr.inra.sad.bagap.apiland.core.element.manager.DynamicLayerFactory;
import fr.inra.sad.bagap.apiland.core.element.manager.Tool;
import fr.inra.sad.bagap.apiland.core.element.type.DynamicElementType;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.JaiMatrixFactory;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixManager;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.util.VisuImageJ;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class AsciiGridManager {
    public static void visualize(String ascii) {
        new VisuImageJ(ascii);
    }

    public static void inverse(String input, String output) {
        try {
            Matrix m = JaiMatrixFactory.get().createWithAsciiGrid(input);
            Matrix m2 = JaiMatrixFactory.get().create(m);
            for (int y = 0; y < m.height(); ++y) {
                for (int x = 0; x < m.width(); ++x) {
                    m2.put(m.width() - x - 1, m.height() - y - 1, m.get(x, y));
                }
            }
            MatrixManager.exportAsciiGrid(m2, output);
        }
        catch (IOException | NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public static void clean(String inAscii, String outAscii) {
        File f = new File(inAscii);
        String tempAscii = f.getParent() + "/" + f.getName().replace(".asc", "") + "_c.asc";
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(f));
            BufferedWriter bw = new BufferedWriter(new FileWriter(tempAscii));
            ArrayList<AsciiGridCleaner> cleaners = new ArrayList<AsciiGridCleaner>();
            cleaners.add(new AddNoDataValueAsciiGridCleaner(bw));
            cleaners.add(new SpaceAsciiGridCleaner());
            cleaners.add(new DecimalCharAsciiGridCleaner());
            cleaners.add(new IntegerAsciiGridCleaner());
            while ((line = br.readLine()) != null) {
                for (AsciiGridCleaner agc : cleaners) {
                    line = agc.clean(line);
                }
                bw.write(line);
                bw.newLine();
            }
            br.close();
            bw.close();
            new File(outAscii).delete();
            new File(tempAscii).renameTo(new File(outAscii));
            System.out.println("netoyage du fichier ascii effectu\u00e9 !");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void searchAndReplace(String inAscii, String outAscii, int noData, Map<Integer, Number> changes) {
        File f = new File(inAscii);
        String tempAscii = f.getParent() + "/" + f.getName().replace(".asc", "") + "_c.asc";
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(f));
            BufferedWriter bw = new BufferedWriter(new FileWriter(tempAscii));
            ArrayList<AsciiGridCleaner> cleaners = new ArrayList<AsciiGridCleaner>();
            cleaners.add(new SpaceAsciiGridCleaner());
            cleaners.add(new DecimalCharAsciiGridCleaner());
            cleaners.add(new IntegerAsciiGridCleaner());
            cleaners.add(new NoDataValueAsciiGridCleaner(noData));
            cleaners.add(new SearchAndReplaceAsciiGridCleaner(changes));
            while ((line = br.readLine()) != null) {
                for (AsciiGridCleaner agc : cleaners) {
                    line = agc.clean(line);
                }
                bw.write(line);
                bw.newLine();
            }
            br.close();
            bw.close();
            new File(tempAscii).renameTo(new File(outAscii));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                Tool.copy(DynamicLayerFactory.class.getResourceAsStream("lambert93.prj"), outAscii.replace(".asc", "") + ".prj");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static <E extends DynamicElement> void exportAsciiGridFromDynamicLayer(String ascii, DynamicLayer<E> layer, Instant t, String attName, double cellsize) {
        AsciiGridManager.exportAsciiGridFromDynamicLayer(ascii, layer, t, attName, cellsize, layer.minX(), layer.maxX(), layer.maxY(), layer.minY());
    }

    public static <E extends DynamicElement> void exportAsciiGridFromDynamicLayer(String ascii, DynamicLayer<E> layer, Instant t, String attName, double cellsize, double minX, double maxX, double minY, double maxY) {
        try {
            BufferedWriter bw;
            Raster.setCellSize(cellsize);
            DynamicElementType type = layer.getType().getElementType();
            if (type.hasAttributeType(attName)) {
                if (maxY < minY) {
                    double temp = maxY;
                    maxY = minY;
                    minY = temp;
                }
                int ncols = new Double(Math.floor((maxX - minX) / cellsize) + 1.0).intValue();
                int nrows = new Double(Math.floor((maxY - minY) / cellsize) + 1.0).intValue();
                bw = new BufferedWriter(new FileWriter(ascii));
                bw.write("ncols " + ncols);
                bw.newLine();
                bw.write("nrows " + nrows);
                bw.newLine();
                bw.write("xllcorner " + minX);
                bw.newLine();
                bw.write("yllcorner " + minY);
                bw.newLine();
                bw.write("cellsize " + cellsize);
                bw.newLine();
                bw.write("NODATA_value " + Raster.getNoDataValue());
                bw.newLine();
                PreparedPoint p = null;
                List l = null;
                DynamicElement ftemp = null;
                double vtemp = Raster.getNoDataValue();
                int modulo = 1;
                WKTReader r = new WKTReader();
                STRtree sIndex = new STRtree();
                for (DynamicElement f : layer) {
                    sIndex.insert(f.getGeometry(t).get().getJTS().getEnvelopeInternal(), (Object)f);
                }
                sIndex.build();
                double yorigin = maxY - minY % cellsize == 0.0 ? minY + Math.floor((maxY - minY) / cellsize) * cellsize : minY + (Math.floor((maxY - minY) / cellsize) + 1.0) * cellsize;
                for (int j = 0; j < nrows; ++j) {
                    System.out.println(j + " / " + nrows);
                    double x = minX + cellsize / 2.0;
                    double y = yorigin - cellsize / 2.0 - (double)j * cellsize;
                    if (j % modulo == 0) {
                        Envelope env = new Envelope(new Coordinate(minX, y + 2.0 * cellsize), new Coordinate(maxX, y - 2.0 * cellsize));
                        l = sIndex.query(env);
                    }
                    for (int i = 0; i < ncols; ++i) {
                        x = minX + cellsize / 2.0 + (double)i * cellsize;
                        boolean ok = false;
                        try {
                            p = new PreparedPoint((Puntal)r.read("POINT (" + x + " " + y + ")"));
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        if (ftemp != null && p.intersects(ftemp.getGeometry(t).get().getJTS())) {
                            bw.write(vtemp + " ");
                            ok = true;
                        }
                        if (!ok) {
                            for (DynamicFeature f : l) {
                                if (!p.intersects(f.getGeometry(t).get().getJTS())) continue;
                                vtemp = new Double(f.getAttribute(attName).getValue(t).toString());
                                ftemp = f;
                                bw.write(vtemp + " ");
                                ok = true;
                                break;
                            }
                        }
                        if (ok) continue;
                        bw.write(Raster.getNoDataValue() + " ");
                    }
                    bw.newLine();
                }
            } else {
                throw new IllegalArgumentException("attribute '" + attName + "' does not exist");
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static <E extends DynamicElement> void exportAsciiGridFromDynamicLayer2(String ascii, DynamicLayer<E> layer, Instant t, String attName, double cellsize, double minX, double maxX, double minY, double maxY) {
        try {
            BufferedWriter bw;
            Raster.setCellSize(cellsize);
            DynamicElementType type = layer.getType().getElementType();
            if (type.hasAttributeType(attName)) {
                int ncols = new Double(Math.floor((maxX - minX) / cellsize) + 1.0).intValue();
                int nrows = new Double(Math.floor((maxY - minY) / cellsize) + 1.0).intValue();
                bw = new BufferedWriter(new FileWriter(ascii));
                bw.write("ncols " + ncols);
                bw.newLine();
                bw.write("nrows " + nrows);
                bw.newLine();
                bw.write("xllcorner " + minX);
                bw.newLine();
                bw.write("yllcorner " + minY);
                bw.newLine();
                bw.write("cellsize " + cellsize);
                bw.newLine();
                bw.write("NODATA_value " + Raster.getNoDataValue());
                bw.newLine();
                TreeMap values = new TreeMap();
                for (Object f : layer) {
                    Geometry geometry = f.getGeometry(t).get().getJTS();
                    String v = f.getAttribute(attName).getValue(t).toString();
                    if (!values.containsKey(v)) {
                        values.put(v, new HashSet());
                    }
                    if (geometry instanceof Polygon) {
                        ((Set)values.get(v)).add((Polygon)f.getGeometry(t).get().getJTS());
                        continue;
                    }
                    if (geometry instanceof MultiPolygon) {
                        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                            ((Set)values.get(v)).add((Polygon)geometry.getGeometryN(i));
                        }
                        continue;
                    }
                    throw new IllegalArgumentException(f.getGeometry(t).get().getJTS() + "");
                }
                TreeMap features = new TreeMap();
                for (Map.Entry entry : values.entrySet()) {
                    Polygon[] pp = new Polygon[((Set)entry.getValue()).size()];
                    int index = 0;
                    for (Polygon p : (Set)entry.getValue()) {
                        pp[index++] = p;
                    }
                    features.put(entry.getKey(), new PreparedPolygon((Polygonal)new MultiPolygon(pp, new GeometryFactory())));
                }
                double yorigin = maxY - minY % cellsize == 0.0 ? minY + Math.floor((maxY - minY) / cellsize) * cellsize : minY + (Math.floor((maxY - minY) / cellsize) + 1.0) * cellsize;
                Point p = null;
                WKTReader r = new WKTReader();
                for (int j = 0; j < nrows; ++j) {
                    System.out.println(j + " / " + nrows);
                    double x = minX + cellsize / 2.0;
                    double y = yorigin - cellsize / 2.0 - (double)j * cellsize;
                    for (int i = 0; i < ncols; ++i) {
                        x = minX + cellsize / 2.0 + (double)i * cellsize;
                        boolean ok = false;
                        try {
                            p = (Point)r.read("POINT (" + x + " " + y + ")");
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        for (Map.Entry pp : features.entrySet()) {
                            if (!((PreparedPolygon)pp.getValue()).intersects((Geometry)p)) continue;
                            bw.write((String)pp.getKey() + " ");
                            ok = true;
                        }
                        if (ok) continue;
                        bw.write(Raster.getNoDataValue() + " ");
                    }
                    bw.newLine();
                }
            } else {
                throw new IllegalArgumentException("attribute '" + attName + "' does not exist");
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static <E extends DynamicElement> void exportAsciiGridFromDynamicLayerWithSingleValue(String ascii, DynamicLayer<E> layer, Instant t, String value, double cellsize) {
        AsciiGridManager.exportAsciiGridFromDynamicLayerWithSingleValue(ascii, layer, t, value, cellsize, layer.minX(), layer.maxX(), layer.maxY(), layer.minY());
    }

    public static <E extends DynamicElement> void exportAsciiGridFromDynamicLayerWithSingleValue(String ascii, DynamicLayer<E> layer, Instant t, String value, double cellsize, double minX, double maxX, double minY, double maxY) {
        try {
            Raster.setCellSize(cellsize);
            int ncols = new Double(Math.floor((maxX - minX) / cellsize) + 1.0).intValue();
            int nrows = new Double(Math.floor((maxY - minY) / cellsize) + 1.0).intValue();
            BufferedWriter bw = new BufferedWriter(new FileWriter(ascii));
            bw.write("ncols " + ncols);
            bw.newLine();
            bw.write("nrows " + nrows);
            bw.newLine();
            bw.write("xllcorner " + minX);
            bw.newLine();
            bw.write("yllcorner " + minY);
            bw.newLine();
            bw.write("cellsize " + cellsize);
            bw.newLine();
            bw.write("NODATA_value " + Raster.getNoDataValue());
            bw.newLine();
            HashSet<Geometry> pp = new HashSet<Geometry>();
            for (DynamicElement e : layer) {
                Geometry g = e.getGeometry(t).get().getJTS();
                if (g instanceof GeometryCollection) {
                    for (int i = 0; i < g.getNumGeometries(); ++i) {
                        pp.add(g.getGeometryN(i));
                    }
                    continue;
                }
                pp.add(g);
            }
            PreparedPolygon ppoly = null;
            if (pp.iterator().next() instanceof Polygon) {
                ppoly = new PreparedPolygon((Polygonal)new MultiPolygon(pp.toArray(new Polygon[pp.size()]), new GeometryFactory()));
            } else if (pp.iterator().next() instanceof LineString) {
                ppoly = new PreparedLineString((Lineal)new MultiLineString(pp.toArray(new LineString[pp.size()]), new GeometryFactory()));
            }
            Point p = null;
            WKTReader r = new WKTReader();
            double yorigin = maxY - minY % cellsize == 0.0 ? minY + Math.floor((maxY - minY) / cellsize) * cellsize : minY + (Math.floor((maxY - minY) / cellsize) + 1.0) * cellsize;
            for (int j = 0; j < nrows; ++j) {
                double x = minX + cellsize / 2.0;
                double y = yorigin - cellsize / 2.0 - (double)j * cellsize;
                for (int i = 0; i < ncols; ++i) {
                    x = minX + cellsize / 2.0 + (double)i * cellsize;
                    try {
                        p = (Point)r.read("POINT (" + x + " " + y + ")");
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (ppoly.intersects(p)) {
                        bw.write(value + " ");
                        continue;
                    }
                    bw.write(Raster.getNoDataValue() + " ");
                }
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static <E extends DynamicElement> void exportAsciiGridFromDynamicLayerWithSingleFeature(String ascii, DynamicLayer<E> layer, Instant t, String value, double cellsize, double minX, double maxX, double minY, double maxY) {
        try {
            Raster.setCellSize(cellsize);
            int ncols = new Double(Math.floor((maxX - minX) / cellsize) + 1.0).intValue();
            int nrows = new Double(Math.floor((maxY - minY) / cellsize) + 1.0).intValue();
            BufferedWriter bw = new BufferedWriter(new FileWriter(ascii));
            bw.write("ncols " + ncols);
            bw.newLine();
            bw.write("nrows " + nrows);
            bw.newLine();
            bw.write("xllcorner " + minX);
            bw.newLine();
            bw.write("yllcorner " + minY);
            bw.newLine();
            bw.write("cellsize " + cellsize);
            bw.newLine();
            bw.write("NODATA_value " + Raster.getNoDataValue());
            bw.newLine();
            PreparedPolygon ppoly = new PreparedPolygon((Polygonal)((DynamicElement)layer.iterator().next()).getGeometry(t).get().getJTS());
            Point p = null;
            WKTReader r = new WKTReader();
            double yorigin = maxY - minY % cellsize == 0.0 ? minY + Math.floor((maxY - minY) / cellsize) * cellsize : minY + (Math.floor((maxY - minY) / cellsize) + 1.0) * cellsize;
            for (int j = 0; j < nrows; ++j) {
                System.out.println(j + " / " + nrows);
                double x = minX + cellsize / 2.0;
                double y = yorigin - cellsize / 2.0 - (double)j * cellsize;
                for (int i = 0; i < ncols; ++i) {
                    x = minX + cellsize / 2.0 + (double)i * cellsize;
                    try {
                        p = (Point)r.read("POINT (" + x + " " + y + ")");
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (ppoly.intersects(p)) {
                        bw.write(value + " ");
                        continue;
                    }
                    bw.write(Raster.getNoDataValue() + " ");
                }
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void exportAsciiGridFromShapefile(String ascii, String shape, String attribute, double cellsize, Map<String, String> map) {
        new ExportAsciiGridFromShapefileAnalysis(ascii, shape, attribute, cellsize, map).allRun();
    }

    public static void exportAsciiGridFromShapefile(String ascii, String shape, String attribute, double cellsize, double minX, double maxX, double minY, double maxY, Map<String, String> map) {
        new ExportAsciiGridFromShapefileAnalysis(ascii, shape, attribute, cellsize, minX, maxX, minY, maxY, map).allRun();
    }
}

