/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.process.metric;

import com.csvreader.CsvReader;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.metric.MatrixMetric;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.core.util.Couple;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class MatrixMetricManager {
    private static Set<String> basicMetrics = new HashSet<String>();
    private static Set<String> valueMetrics = new HashSet<String>();
    private static Set<String> coupleMetrics = new HashSet<String>();
    private static Set<String> setMetrics = new HashSet<String>();
    private static Set<String> valuesMetrics = new HashSet<String>();
    private static Set<String> couplesMetrics = new HashSet<String>();
    private static Set<String> patchMetrics = new HashSet<String>();
    private static Set<String> connectivityMetrics = new HashSet<String>();
    private static Set<String> diversityMetrics = new HashSet<String>();
    private static Set<String> grainMetrics = new HashSet<String>();
    private static Set<String> quantitativeMetrics = new TreeSet<String>();
    private static Set<String> statsMetrics = new TreeSet<String>();
    private static Map<String, String> metrics = new HashMap<String, String>();

    public static boolean isBasicMetric(String m) {
        for (String metric : basicMetrics) {
            if (!m.startsWith(metric)) continue;
            return true;
        }
        return false;
    }

    private static String getBasicMetric(String m) {
        for (String metric : basicMetrics) {
            if (!m.startsWith(metric)) continue;
            return metric;
        }
        throw new IllegalArgumentException();
    }

    private static boolean isSetMetric(String m) {
        for (String metric : setMetrics) {
            if (!m.startsWith(metric)) continue;
            return true;
        }
        return false;
    }

    private static String getSetMetric(String m) {
        for (String metric : setMetrics) {
            if (!m.startsWith(metric)) continue;
            return metric;
        }
        throw new IllegalArgumentException();
    }

    private static boolean isCoupleMetric(String m) {
        for (String metric : coupleMetrics) {
            if (!m.startsWith(metric + "_")) continue;
            return true;
        }
        return false;
    }

    private static String getCoupleMetric(String m) {
        for (String metric : coupleMetrics) {
            if (!m.startsWith(metric)) continue;
            return metric;
        }
        throw new IllegalArgumentException();
    }

    private static boolean isValueMetric(String m) {
        for (String metric : valueMetrics) {
            if (!m.startsWith(metric)) continue;
            return true;
        }
        return false;
    }

    private static String getValueMetric(String m) {
        for (String metric : valueMetrics) {
            if (!m.startsWith(metric)) continue;
            return metric;
        }
        throw new IllegalArgumentException();
    }

    public static boolean isStatsMetric(String m) {
        for (String metric : statsMetrics) {
            if (!m.startsWith(metric)) continue;
            return true;
        }
        return false;
    }

    private static String getStatsMetric(String m) {
        for (String metric : statsMetrics) {
            if (!m.startsWith(metric)) continue;
            return metric;
        }
        throw new IllegalArgumentException();
    }

    public static MatrixMetric get(String m, Metric refMetric) {
        try {
            if (MatrixMetricManager.isStatsMetric(m)) {
                String metric = MatrixMetricManager.getStatsMetric(m);
                Class<?> c = Class.forName(metrics.get(metric));
                return (MatrixMetric)c.getConstructor(Metric.class).newInstance(refMetric);
            }
            throw new IllegalArgumentException();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException();
    }

    public static MatrixMetric get(String m) {
        try {
            if (MatrixMetricManager.isSetMetric(m)) {
                String metric = MatrixMetricManager.getSetMetric(m);
                Class<?> c = Class.forName(metrics.get(metric));
                HashSet<Integer> set = new HashSet<Integer>();
                metric = m.replace(metric + "_", "");
                StringTokenizer st = new StringTokenizer(metric, "-");
                while (st.hasMoreTokens()) {
                    set.add(new Integer(st.nextToken()));
                }
                return (MatrixMetric)c.getConstructor(Set.class).newInstance(set);
            }
            if (MatrixMetricManager.isCoupleMetric(m)) {
                String metric = MatrixMetricManager.getCoupleMetric(m);
                Class<?> c = Class.forName(metrics.get(metric));
                metric = m.replace(metric + "_", "");
                StringTokenizer st = new StringTokenizer(metric, "-");
                int c1 = new Integer(st.nextToken());
                int c2 = new Integer(st.nextToken());
                return (MatrixMetric)c.getConstructor(Integer.class, Integer.class).newInstance(c1, c2);
            }
            if (MatrixMetricManager.isValueMetric(m)) {
                String metric = MatrixMetricManager.getValueMetric(m);
                Class<?> c = Class.forName(metrics.get(metric));
                metric = m.replace(metric + "_", "");
                int v = new Integer(metric);
                return (MatrixMetric)c.getConstructor(Integer.class).newInstance(v);
            }
            if (MatrixMetricManager.isStatsMetric(m)) {
                throw new IllegalArgumentException();
            }
            Class<?> c = Class.forName(metrics.get(m));
            return (MatrixMetric)c.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException();
    }

    public static Set<String> getMetricNames() {
        return metrics.keySet();
    }

    public static int getMetricSize() {
        return metrics.size();
    }

    public static Set<String> getStatsMetricNames(Set<String> m) {
        TreeSet<String> metrics = new TreeSet<String>();
        for (String sm : statsMetrics) {
            for (String bm : m) {
                metrics.add(sm + "_" + bm);
            }
        }
        return metrics;
    }

    public static Set<String> getGrainMetricNames(Set<Integer> values) {
        TreeSet<String> metrics = new TreeSet<String>();
        for (String m : grainMetrics) {
            if (valueMetrics.contains(m)) {
                if (values.size() >= 50) continue;
                Iterator<Object> iterator = values.iterator();
                while (iterator.hasNext()) {
                    int v = iterator.next();
                    metrics.add(m + "_" + v);
                }
                continue;
            }
            if (coupleMetrics.contains(m)) {
                if (values.size() >= 250) continue;
                for (String cou : MatrixMetricManager.getCouples(values)) {
                    metrics.add(m + "_" + cou);
                }
                continue;
            }
            if (setMetrics.contains(m)) {
                for (String comb : MatrixMetricManager.getCombinations(values)) {
                    metrics.add(m + "_" + comb);
                }
                continue;
            }
            metrics.add(m);
        }
        return metrics;
    }

    public static Set<String> getDiversityMetricNames(Set<Integer> values) {
        TreeSet<String> metrics = new TreeSet<String>();
        for (String m : diversityMetrics) {
            if (valueMetrics.contains(m)) {
                if (values.size() >= 50) continue;
                Iterator<Object> iterator = values.iterator();
                while (iterator.hasNext()) {
                    int v = iterator.next();
                    metrics.add(m + "_" + v);
                }
                continue;
            }
            if (coupleMetrics.contains(m)) {
                if (values.size() >= 250) continue;
                for (String cou : MatrixMetricManager.getCouples(values)) {
                    metrics.add(m + "_" + cou);
                }
                continue;
            }
            if (setMetrics.contains(m)) {
                for (String comb : MatrixMetricManager.getCombinations(values)) {
                    metrics.add(m + "_" + comb);
                }
                continue;
            }
            metrics.add(m);
        }
        return metrics;
    }

    public static Set<String> getConnectivityMetricNames(Set<Integer> values) {
        TreeSet<String> metrics = new TreeSet<String>();
        for (String m : connectivityMetrics) {
            if (valueMetrics.contains(m)) {
                if (values.size() >= 50) continue;
                Iterator<Object> iterator = values.iterator();
                while (iterator.hasNext()) {
                    int v = iterator.next();
                    metrics.add(m + "_" + v);
                }
                continue;
            }
            if (coupleMetrics.contains(m)) {
                if (values.size() >= 250) continue;
                for (String cou : MatrixMetricManager.getCouples(values)) {
                    metrics.add(m + "_" + cou);
                }
                continue;
            }
            if (setMetrics.contains(m)) {
                for (String comb : MatrixMetricManager.getCombinations(values)) {
                    metrics.add(m + "_" + comb);
                }
                continue;
            }
            metrics.add(m);
        }
        return metrics;
    }

    public static Set<String> getPatchMetricNames(Set<Integer> values) {
        TreeSet<String> metrics = new TreeSet<String>();
        for (String m : patchMetrics) {
            if (valueMetrics.contains(m)) {
                if (values.size() >= 50) continue;
                Iterator<Object> iterator = values.iterator();
                while (iterator.hasNext()) {
                    int v = iterator.next();
                    metrics.add(m + "_" + v);
                }
                continue;
            }
            if (coupleMetrics.contains(m)) {
                if (values.size() >= 250) continue;
                for (String cou : MatrixMetricManager.getCouples(values)) {
                    metrics.add(m + "_" + cou);
                }
                continue;
            }
            if (setMetrics.contains(m)) {
                for (String comb : MatrixMetricManager.getCombinations(values)) {
                    metrics.add(m + "_" + comb);
                }
                continue;
            }
            metrics.add(m);
        }
        return metrics;
    }

    public static Set<String> getCoupleMetricNames(Set<Integer> values) {
        TreeSet<String> metrics = new TreeSet<String>();
        for (String m : couplesMetrics) {
            if (valueMetrics.contains(m)) {
                if (values.size() >= 50) continue;
                Iterator<Object> iterator = values.iterator();
                while (iterator.hasNext()) {
                    int v = iterator.next();
                    metrics.add(m + "_" + v);
                }
                continue;
            }
            if (coupleMetrics.contains(m)) {
                if (values.size() >= 250) continue;
                for (String cou : MatrixMetricManager.getCouples(values)) {
                    metrics.add(m + "_" + cou);
                }
                continue;
            }
            if (setMetrics.contains(m)) {
                for (String comb : MatrixMetricManager.getCombinations(values)) {
                    metrics.add(m + "_" + comb);
                }
                continue;
            }
            metrics.add(m);
        }
        return metrics;
    }

    public static Set<String> getValueMetricNames(Set<Integer> values) {
        TreeSet<String> metrics = new TreeSet<String>();
        for (String m : valuesMetrics) {
            if (valueMetrics.contains(m)) {
                if (values.size() >= 50) continue;
                Iterator<Object> iterator = values.iterator();
                while (iterator.hasNext()) {
                    int v = iterator.next();
                    metrics.add(m + "_" + v);
                }
                continue;
            }
            if (coupleMetrics.contains(m)) {
                if (values.size() >= 250) continue;
                for (String cou : MatrixMetricManager.getCouples(values)) {
                    metrics.add(m + "_" + cou);
                }
                continue;
            }
            if (setMetrics.contains(m)) {
                for (String comb : MatrixMetricManager.getCombinations(values)) {
                    metrics.add(m + "_" + comb);
                }
                continue;
            }
            metrics.add(m);
        }
        return metrics;
    }

    private static Set<String> getCombinations(Set<Integer> values) {
        HashSet<String> combinations = new HashSet<String>();
        if (values.size() > 2) {
            HashSet set = new HashSet();
            for (int i = 0; i < values.size() - 1; ++i) {
                HashSet temp = new HashSet();
                Iterator<Object> iterator = values.iterator();
                while (iterator.hasNext()) {
                    HashSet<Integer> s;
                    double v = ((Integer)iterator.next()).intValue();
                    for (Set ss : set) {
                        s = new HashSet(ss);
                        s.add((int)v);
                        temp.add(s);
                    }
                    s = new HashSet<Integer>();
                    s.add((int)v);
                    temp.add(s);
                }
                set.addAll(temp);
            }
            for (Set ss : set) {
                if (ss.size() <= 1) continue;
                StringBuffer combination = new StringBuffer();
                Iterator iterator = ss.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    combination.append(i);
                    combination.append('-');
                }
                combinations.add(combination.subSequence(0, combination.length() - 1).toString());
            }
        }
        return combinations;
    }

    private static Set<String> getCouples(Set<Integer> values) {
        HashSet<String> couples = new HashSet<String>();
        TreeSet<Double> ever = new TreeSet<Double>();
        Iterator<Integer> iterator = values.iterator();
        while (iterator.hasNext()) {
            double v1 = iterator.next().intValue();
            Iterator<Integer> iterator2 = values.iterator();
            while (iterator2.hasNext()) {
                double v2 = iterator2.next().intValue();
                double c = Couple.get(v1, v2);
                if (ever.contains(c)) continue;
                couples.add((int)v1 + "-" + (int)v2);
                ever.add(c);
            }
        }
        return couples;
    }

    public static Set<String> getQuantitativeMetricNames() {
        return quantitativeMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try (CsvReader cr = null;){
            BufferedReader buf = new BufferedReader(new InputStreamReader(MatrixMetricManager.class.getResourceAsStream("metrics_2017.csv")));
            cr = new CsvReader((Reader)buf);
            cr.setDelimiter(';');
            cr.readHeaders();
            while (cr.readRecord()) {
                if (cr.get("name").startsWith("#")) continue;
                metrics.put(cr.get("name"), cr.get("class"));
                if (cr.get("basic").equalsIgnoreCase("true")) {
                    basicMetrics.add(cr.get("name"));
                }
                switch (cr.get("process")) {
                    case "value": {
                        valuesMetrics.add(cr.get("name"));
                        break;
                    }
                    case "couple": {
                        couplesMetrics.add(cr.get("name"));
                        break;
                    }
                    case "patch": {
                        patchMetrics.add(cr.get("name"));
                        break;
                    }
                    case "connectivity": {
                        connectivityMetrics.add(cr.get("name"));
                        break;
                    }
                    case "diversity": {
                        diversityMetrics.add(cr.get("name"));
                        break;
                    }
                    case "grain": {
                        grainMetrics.add(cr.get("name"));
                        break;
                    }
                    case "quantitative": {
                        quantitativeMetrics.add(cr.get("name"));
                    }
                }
                if (cr.get("type").equalsIgnoreCase("value")) {
                    valueMetrics.add(cr.get("name"));
                    continue;
                }
                if (cr.get("type").equalsIgnoreCase("couple")) {
                    coupleMetrics.add(cr.get("name"));
                    continue;
                }
                if (cr.get("type").equalsIgnoreCase("set")) {
                    setMetrics.add(cr.get("name"));
                    continue;
                }
                if (!cr.get("type").equalsIgnoreCase("metric")) continue;
                statsMetrics.add(cr.get("name"));
            }
        }
    }
}

